/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co;

import cn.nkpro.elcube.co.DebugContextManager;
import cn.nkpro.elcube.co.NkCustomObject;
import cn.nkpro.elcube.co.NkCustomObjectDesc;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class NkCustomObjectManager
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Autowired
    private DebugContextManager applicationContextManager;

    public <T extends NkCustomObject> Map<String, T> getCustomObjects(Class<T> clazz) {
        Map beansMap = this.applicationContext.getBeansOfType(clazz);
        if (this.applicationContextManager.getApplicationContext() != this.applicationContext) {
            beansMap.putAll(this.applicationContextManager.getApplicationContext().getBeansOfType(clazz));
        }
        return beansMap;
    }

    public List<NkCustomObjectDesc> getCustomObjectDescriptionList(Class<? extends NkCustomObject> clazz, boolean emptyValue, Predicate<Map.Entry<String, ? extends NkCustomObject>> predicate) {
        if (predicate == null) {
            predicate = e -> true;
        }
        List<NkCustomObjectDesc> list = this.getCustomObjects(clazz).entrySet().stream().filter(predicate).map(e -> new NkCustomObjectDesc((String)e.getKey(), ((NkCustomObject)e.getValue()).desc(), ((NkCustomObject)e.getValue()).order())).sorted((o1, o2) -> {
            if (o1.getOrder() == o2.getOrder()) {
                return o1.getName().compareTo(o2.getName());
            }
            return o1.getOrder() - o2.getOrder();
        }).collect(Collectors.toList());
        if (emptyValue) {
            list.add(0, new NkCustomObjectDesc("", "\u7a7a\u914d\u7f6e"));
        }
        return list;
    }

    public <T extends NkCustomObject> T getCustomObject(String beanName, Class<T> clazz) {
        Assert.isTrue((boolean)this.applicationContextManager.getApplicationContext().containsBean(beanName), (String)String.format("\u81ea\u5b9a\u4e49\u5bf9\u8c61[%s]\u4e0d\u5b58\u5728\u6216\u5c1a\u672a\u6fc0\u6d3b", beanName));
        return (T)((NkCustomObject)this.applicationContextManager.getApplicationContext().getBean(beanName, clazz));
    }

    public <T extends NkCustomObject> T getCustomObjectIfExists(String beanName, Class<T> clazz) {
        if (StringUtils.isNotBlank((CharSequence)beanName) && this.applicationContextManager.getApplicationContext().containsBean(beanName)) {
            return (T)((NkCustomObject)this.applicationContextManager.getApplicationContext().getBean(beanName, clazz));
        }
        return null;
    }

    public void assertExists(String beanName) {
        Assert.isTrue((boolean)this.applicationContextManager.getApplicationContext().containsBean(beanName), (String)String.format("\u81ea\u5b9a\u4e49\u5bf9\u8c61[%s]\u4e0d\u5b58\u5728\u6216\u5c1a\u672a\u6fc0\u6d3b", beanName));
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

