/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.annotation.NkScriptType;
import cn.nkpro.elcube.basic.NkProperties;
import cn.nkpro.elcube.co.NkCustomScriptObject;
import cn.nkpro.elcube.co.NkScriptV;
import cn.nkpro.elcube.exception.NkDefineException;
import cn.nkpro.elcube.utils.ClassUtils;
import cn.nkpro.elcube.utils.GroovyUtils;
import cn.nkpro.elcube.utils.ResourceUtils;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

public abstract class NkAbstractCustomScriptObject
implements NkCustomScriptObject,
InitializingBean {
    @Autowired
    private NkProperties properties;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    protected String beanName = this.parseComponentName();
    protected NkScriptV scriptDef;

    public final void afterPropertiesSet() {
        if (this.scriptDef == null) {
            this.scriptDef = this.loadScriptFromClassPath();
        }
        if (this.scriptDef == null) {
            this.scriptDef = new NkScriptV();
            this.scriptDef.setScriptType("Unknown");
            this.scriptDef.setScriptName(this.beanName);
            this.scriptDef.setVersion("@");
            this.scriptDef.setGroovyMain(null);
            this.scriptDef.setVueMain(null);
            this.scriptDef.setVueDefs(null);
            this.scriptDef.setState("Native");
        }
    }

    protected NkScriptV scriptDefHV() {
        NkScriptV defHV;
        if (!this.scriptDef.isDebug() && this.properties.isComponentReloadClassPath() && (defHV = this.loadScriptFromClassPath()) != null) {
            return defHV;
        }
        return this.scriptDef;
    }

    private NkScriptV loadScriptFromClassPath() {
        String className = this.getClass().getSimpleName();
        List<String> groovyCode = this.findResource(className + ".groovy");
        if (!groovyCode.isEmpty()) {
            List<String> vueMainCode = this.findResource(className + ".vue");
            List<String> vueDefsCode = this.findResource(className + "Def*.vue");
            NkScriptV scriptDefH = new NkScriptV();
            scriptDefH.setScriptName(this.beanName);
            scriptDefH.setVersion("@");
            scriptDefH.setGroovyMain(groovyCode.stream().findFirst().orElse(null));
            scriptDefH.setVueMain(vueMainCode.stream().findFirst().orElse(null));
            scriptDefH.setVueDefs(CollectionUtils.isEmpty(vueDefsCode) ? null : JSON.toJSONString(vueDefsCode));
            scriptDefH.setState("Active");
            Class<?> groovy = GroovyUtils.compileGroovy(className, scriptDefH.getGroovyMain());
            List interfaces = org.apache.commons.lang3.ClassUtils.getAllInterfaces(groovy);
            if (!interfaces.contains(NkCustomScriptObject.class)) {
                throw new NkDefineException("\u7ec4\u4ef6\u5fc5\u987b\u5b9e\u73b0NkScriptObject\u63a5\u53e3");
            }
            scriptDefH.setScriptType(interfaces.stream().map(i -> i.getAnnotation(NkScriptType.class)).filter(Objects::nonNull).findFirst().map(NkScriptType::value).orElse("Service"));
            NkNote annotation = groovy.getAnnotation(NkNote.class);
            scriptDefH.setScriptDesc(annotation != null ? annotation.value() : this.beanName);
            return scriptDefH;
        }
        return null;
    }

    private String parseComponentName() {
        Class<?> clazz = this.getClass();
        Component component = clazz.getDeclaredAnnotation(Component.class);
        if (component != null && StringUtils.isNotBlank((CharSequence)component.value())) {
            return component.value();
        }
        Service service = clazz.getDeclaredAnnotation(Service.class);
        if (service != null && StringUtils.isNotBlank((CharSequence)service.value())) {
            return service.value();
        }
        return ClassUtils.decapitateClassName(clazz.getSimpleName());
    }

    private List<String> findResource(String resourceName) {
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String path : this.properties.getComponentBasePackages()) {
                resources.addAll(Arrays.asList(this.resourcePatternResolver.getResources(String.format("classpath*:/%s/**/%s", this.packageToPath(path), resourceName))));
            }
            return resources.stream().map(ResourceUtils::readText).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private String packageToPath(String packageName) {
        if ((packageName = packageName.replaceAll("[.]", "/")).startsWith("/")) {
            packageName = packageName.substring(1);
        }
        if (packageName.endsWith("/")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        return packageName;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public void setScriptDef(NkScriptV scriptDef) {
        this.scriptDef = scriptDef;
    }

    @Override
    public NkScriptV getScriptDef() {
        return this.scriptDef;
    }
}

