/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co;

import cn.nkpro.elcube.co.fs.FSSupport;
import cn.nkpro.elcube.co.fs.defaults.DefaultFileSupportAliyunOSS;
import cn.nkpro.elcube.co.fs.defaults.DefaultFileSupportHuaweiOBS;
import cn.nkpro.elcube.co.fs.defaults.DefaultFileSupportImpl;
import cn.nkpro.elcube.co.fs.properties.AliyunProperties;
import cn.nkpro.elcube.co.fs.properties.HuaweiProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={AliyunProperties.class, HuaweiProperties.class})
public class FSAutoConfiguration {
    @Order(value=0)
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"tfms.huawei.obs.bucket"})
    @Bean
    public FSSupport defaultFileSupportHuaweiOBS() {
        return new DefaultFileSupportHuaweiOBS();
    }

    @Order(value=1)
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"tfms.aliyun.oss.bucket"})
    @Bean
    public FSSupport defaultAliyunOSSFileSupport() {
        return new DefaultFileSupportAliyunOSS();
    }

    @Order
    @ConditionalOnMissingBean
    @Bean
    public FSSupport defaultFileSupport() {
        return new DefaultFileSupportImpl();
    }
}

