/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co;

import cn.nkpro.elcube.annotation.Keep;
import cn.nkpro.elcube.co.DebugAble;
import cn.nkpro.elcube.co.NkCustomObject;
import cn.nkpro.elcube.co.NkCustomScriptObject;
import cn.nkpro.elcube.co.NkScriptV;
import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.exception.NkDebugContextNotFoundException;
import cn.nkpro.elcube.exception.NkSystemException;
import cn.nkpro.elcube.utils.GroovyUtils;
import cn.nkpro.elcube.utils.OsUtils;
import groovy.lang.GroovyObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class DebugContextManager
implements ApplicationContextAware {
    private static final Map<String, ApplicationContext> debugApplications = new ConcurrentHashMap<String, ApplicationContext>();
    private static final ThreadLocal<String> localDebugId = new ThreadLocal();
    private static final ThreadLocal<ByteArrayOutputStream> localOutput = new ThreadLocal();
    private ApplicationContext rootApplicationContext;
    @Autowired
    private RedisSupport<Object> redisForResoure;
    @Autowired
    private RedisSupport<ContextDescribe> redisForContext;

    public Collection<ContextDescribe> getDebugContextList() {
        Map<String, ContextDescribe> absent = this.redisForContext.getHash("DEBUG_CONTEXT");
        if (absent != null) {
            return absent.values().stream().peek(item -> item.setVisible(StringUtils.equals((CharSequence)item.getMac(), (CharSequence)OsUtils.getMacAddress()))).collect(Collectors.toList());
        }
        return null;
    }

    public String createContext(String desc, String username) {
        String debugId = UUID.randomUUID().toString();
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.setParent(this.rootApplicationContext);
        context.refresh();
        debugApplications.put(debugId, (ApplicationContext)context);
        this.redisForContext.set("DEBUG_CONTEXT", debugId, new ContextDescribe(debugId, OsUtils.getMacAddress(), username, desc, true));
        return debugId;
    }

    public void removeContext(String debugId) {
        ApplicationContext context = debugApplications.remove(debugId);
        if (context != null) {
            ((GenericApplicationContext)context).stop();
        }
        this.redisForResoure.delete(String.format("DEBUG:%s", debugId));
        this.redisForResoure.deleteHash("DEBUG_CONTEXT", debugId);
    }

    void startThreadLocal(String debugId) {
        ContextDescribe debugContext = this.redisForContext.getIfAbsent("DEBUG_CONTEXT", debugId, () -> null);
        if (debugContext == null) {
            throw new NkDebugContextNotFoundException("\u5f53\u524d\u8c03\u8bd5\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728");
        }
        if (!StringUtils.equals((CharSequence)OsUtils.getMacAddress(), (CharSequence)debugContext.getMac())) {
            throw new NkDebugContextNotFoundException("\u5f53\u524d\u8c03\u8bd5\u4e0a\u4e0b\u6587\u4e0e\u8fd0\u884c\u73af\u5883\u4e0d\u4e00\u81f4");
        }
        if (!debugApplications.containsKey(debugId)) {
            AnnotationConfigApplicationContext debugApplicationContext = new AnnotationConfigApplicationContext();
            debugApplicationContext.setParent(this.rootApplicationContext);
            debugApplicationContext.refresh();
            debugApplications.put(debugId, (ApplicationContext)debugApplicationContext);
            Optional.ofNullable(this.redisForResoure.getHash(String.format("DEBUG:%s", debugId))).ifPresent(map -> map.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("#")).map(Map.Entry::getValue).forEach(e -> this.registerScriptObject((NkScriptV)e, (ApplicationContext)debugApplicationContext, true)));
        }
        localDebugId.set(debugId);
        localOutput.set(new ByteArrayOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String exitThreadLocal() {
        ByteArrayOutputStream output = null;
        try {
            output = localOutput.get();
            if (output != null) {
                String string = new String(output.toByteArray());
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            localOutput.remove();
            localDebugId.remove();
            if (output != null) {
                try {
                    output.flush();
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addDebugResource(String key, Object resource) {
        ApplicationContext debugApplicationContext = Optional.ofNullable(localDebugId.get()).map(debugApplications::get).orElseThrow(() -> new NkSystemException("\u6ca1\u6709\u627e\u5230\u8c03\u8bd5\u4e0a\u4e0b\u6587"));
        if (resource instanceof NkScriptV) {
            ((NkScriptV)resource).setDebug(true);
            this.registerScriptObject((NkScriptV)resource, debugApplicationContext, true);
        } else if (resource instanceof DebugAble) {
            ((DebugAble)resource).setDebug(true);
        } else {
            throw new NkSystemException(resource.getClass().getName() + " \u4e0d\u652f\u6301\u8c03\u8bd5");
        }
        this.redisForResoure.set(String.format("DEBUG:%s", localDebugId.get()), key, resource);
    }

    public void addActiveResource(String key, NkScriptV scriptDef, boolean rewrite) {
        scriptDef.setDebug(false);
        this.registerScriptObject(scriptDef, this.rootApplicationContext, rewrite);
        this.removeDebugResource(key, scriptDef);
    }

    public void removeDebugResource(String key, Object resource) {
        if (resource instanceof NkScriptV) {
            ((NkScriptV)resource).setDebug(false);
            Optional.ofNullable(localDebugId.get()).map(debugApplications::get).ifPresent(debugApplicationContext -> {
                String scriptName = ((NkScriptV)resource).getScriptName();
                BeanDefinitionRegistry definitionRegistry = (BeanDefinitionRegistry)debugApplicationContext.getAutowireCapableBeanFactory();
                if (definitionRegistry.containsBeanDefinition(scriptName)) {
                    definitionRegistry.removeBeanDefinition(scriptName);
                }
            });
        } else if (resource instanceof DebugAble) {
            ((DebugAble)resource).setDebug(false);
        }
        this.redisForResoure.deleteHash(String.format("DEBUG:%s", localDebugId.get()), key);
    }

    private void registerScriptObject(NkScriptV scriptDef, ApplicationContext context, boolean rewrite) {
        Class<?> clazz = GroovyUtils.compileGroovy(scriptDef.getScriptName(), scriptDef.getGroovyMain());
        if (!ClassUtils.getAllInterfaces(clazz).contains(NkCustomScriptObject.class)) {
            throw new RuntimeException("\u7ec4\u4ef6\u5904\u7406\u7a0b\u5e8f\u5fc5\u987b\u5b9e\u73b0[ " + NkCustomScriptObject.class.getSimpleName() + " ]");
        }
        String beanName = cn.nkpro.elcube.utils.ClassUtils.decapitateBeanName(clazz);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)beanName, (CharSequence)scriptDef.getScriptName()), (String)"\u5bf9\u8c61\u540d\u79f0\u4e0e\u811a\u672c\u540d\u79f0\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4");
        if (context.containsBean(beanName)) {
            if (!rewrite) {
                return;
            }
            Object exists = context.getBean(beanName);
            if (!(exists instanceof GroovyObject)) {
                if (exists instanceof NkCustomObject) {
                    if (((NkCustomObject)exists).isFinal()) {
                        throw new RuntimeException(String.format("%s \u4e0d\u652f\u6301\u91cd\u5199", exists.getClass().getName()));
                    }
                } else {
                    throw new RuntimeException(String.format("%s \u4e0d\u652f\u6301\u91cd\u5199", exists.getClass().getName()));
                }
            }
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        beanDefinitionBuilder.addPropertyValue("scriptDef", (Object)scriptDef);
        ((BeanDefinitionRegistry)context.getAutowireCapableBeanFactory()).registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    public boolean isDebug() {
        return localDebugId.get() != null;
    }

    public <T> T getDebugResource(String key) {
        if (localDebugId.get() != null) {
            return (T)this.redisForResoure.getIfAbsent(String.format("DEBUG:%s", localDebugId.get()), key, () -> null);
        }
        return null;
    }

    public <T> List<T> getDebugResources(String ... keyPrefix) {
        Map<String, Object> hashIfAbsent;
        if (localDebugId.get() != null && (hashIfAbsent = this.redisForResoure.getHash(String.format("DEBUG:%s", localDebugId.get()))) != null) {
            return hashIfAbsent.entrySet().stream().filter(e -> Arrays.stream(keyPrefix).filter(p -> ((String)e.getKey()).startsWith((String)p)).findFirst().isPresent()).map(e -> e.getValue()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public ApplicationContext getApplicationContext() {
        return Optional.ofNullable(localDebugId.get()).map(debugApplications::get).orElse(this.rootApplicationContext);
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.rootApplicationContext = applicationContext;
        final PrintStream systemOut = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                if (localOutput.get() != null) {
                    ((ByteArrayOutputStream)localOutput.get()).write(b);
                }
                systemOut.write(b);
            }
        }));
    }

    @Keep
    public static class ContextDescribe
    implements Serializable {
        private String id;
        private String mac;
        private String createUser;
        private String contextDesc;
        private boolean visible;

        public ContextDescribe() {
        }

        public ContextDescribe(String id, String mac, String createUser, String contextDesc, boolean visible) {
            this.id = id;
            this.mac = mac;
            this.createUser = createUser;
            this.contextDesc = contextDesc;
            this.visible = visible;
        }

        public String getId() {
            return this.id;
        }

        public String getMac() {
            return this.mac;
        }

        public String getCreateUser() {
            return this.createUser;
        }

        public String getContextDesc() {
            return this.contextDesc;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }

        public void setCreateUser(String createUser) {
            this.createUser = createUser;
        }

        public void setContextDesc(String contextDesc) {
            this.contextDesc = contextDesc;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContextDescribe)) {
                return false;
            }
            ContextDescribe other = (ContextDescribe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$mac = this.getMac();
            String other$mac = other.getMac();
            if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
                return false;
            }
            String this$createUser = this.getCreateUser();
            String other$createUser = other.getCreateUser();
            if (this$createUser == null ? other$createUser != null : !this$createUser.equals(other$createUser)) {
                return false;
            }
            String this$contextDesc = this.getContextDesc();
            String other$contextDesc = other.getContextDesc();
            if (this$contextDesc == null ? other$contextDesc != null : !this$contextDesc.equals(other$contextDesc)) {
                return false;
            }
            return this.isVisible() == other.isVisible();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContextDescribe;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $mac = this.getMac();
            result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
            String $createUser = this.getCreateUser();
            result = result * 59 + ($createUser == null ? 43 : $createUser.hashCode());
            String $contextDesc = this.getContextDesc();
            result = result * 59 + ($contextDesc == null ? 43 : $contextDesc.hashCode());
            result = result * 59 + (this.isVisible() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "DebugContextManager.ContextDescribe(id=" + this.getId() + ", mac=" + this.getMac() + ", createUser=" + this.getCreateUser() + ", contextDesc=" + this.getContextDesc() + ", visible=" + this.isVisible() + ")";
        }
    }
}

