/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co;

import cn.nkpro.elcube.co.DebugContextManager;
import cn.nkpro.elcube.data.redis.RedisSupport;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class DebugContextConfigurer
implements WebMvcConfigurer {
    @Autowired
    private DebugContextManager applicationContextManager;
    @Autowired
    private RedisSupport<String> redis;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new DebugHandlerInterceptor());
    }

    class DebugHandlerInterceptor
    implements HandlerInterceptor {
        DebugHandlerInterceptor() {
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
            String debugId = request.getHeader("NK-Debug");
            if (StringUtils.isNotBlank((CharSequence)debugId)) {
                response.setHeader("NK-Debug-Log", UUID.randomUUID().toString());
                DebugContextConfigurer.this.applicationContextManager.startThreadLocal(debugId);
            }
            return true;
        }

        public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
            String output = DebugContextConfigurer.this.applicationContextManager.exitThreadLocal();
            String logId = response.getHeader("NK-Debug-Log");
            if (output != null && logId != null) {
                DebugContextConfigurer.this.redis.set(logId, output);
                DebugContextConfigurer.this.redis.expire(logId, 30L);
            }
        }
    }
}

