/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.basic.secret;

import cn.nkpro.elcube.basic.secret.DesCbcUtil;
import cn.nkpro.elcube.basic.secret.SecretHttpMessage;
import cn.nkpro.elcube.basic.secret.SecretProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ControllerAdvice
@ConditionalOnProperty(prefix="faster.secret", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={SecretProperties.class})
@Order(value=1)
public class SecretRequestAdvice
extends RequestBodyAdviceAdapter {
    private static final Logger log = LoggerFactory.getLogger(SecretRequestAdvice.class);
    @Autowired
    private SecretProperties secretProperties;

    private boolean supportSecretRequest(MethodParameter methodParameter) {
        if (!this.secretProperties.isScanAnnotation()) {
            return true;
        }
        if (methodParameter.getContainingClass().getAnnotation(this.secretProperties.getAnnotationClass()) != null) {
            return true;
        }
        return methodParameter.getMethodAnnotation(this.secretProperties.getAnnotationClass()) != null;
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        String httpBody;
        boolean supportSafeMessage = this.supportSecretRequest(parameter);
        if (supportSafeMessage) {
            httpBody = this.decryptBody(inputMessage);
            if (httpBody == null) {
                throw new HttpMessageNotReadableException("request body decrypt error", inputMessage);
            }
        } else {
            httpBody = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)Charset.defaultCharset());
        }
        return new SecretHttpMessage(new ByteArrayInputStream(httpBody.getBytes()), inputMessage.getHeaders());
    }

    private String decryptBody(HttpInputMessage inputMessage) throws IOException {
        InputStream encryptStream = inputMessage.getBody();
        String encryptBody = StreamUtils.copyToString((InputStream)encryptStream, (Charset)Charset.defaultCharset());
        return DesCbcUtil.decode(encryptBody, this.secretProperties.getDesSecretKey(), this.secretProperties.getDesIv());
    }
}

