/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.basic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionSync {
    private static final Logger log = LoggerFactory.getLogger(TransactionSync.class);
    private static final ThreadLocal<List<Handler>> tasksRunAfterCommit = new ThreadLocal();
    private static final ThreadLocal<List<Handler>> tasksRunBeforeCommit = new ThreadLocal();
    private static final ThreadLocal<List<HandlerCompletion>> tasksRunAfterCompletion = new ThreadLocal();
    private static final ThreadLocal<Boolean> lock = new ThreadLocal();
    private static TransactionSynchronization transactionSync = new TransactionSynchronizationAdapter(){

        public void beforeCommit(boolean readOnly) {
            super.beforeCommit(readOnly);
            TransactionSync.lock();
            List handlers = (List)tasksRunBeforeCommit.get();
            if (handlers != null) {
                log.info("* >>>>>>>> \u51c6\u5907\u6267\u884c\u4e8b\u52a1\u63d0\u4ea4\u524d\u7684\u4efb\u52a1\uff0c\u4efb\u52a1\u6570\u91cf = {}", (Object)handlers.size());
                tasksRunBeforeCommit.remove();
                Handler last = null;
                try {
                    Iterator iterator = handlers.stream().sorted().collect(Collectors.toList()).iterator();
                    while (iterator.hasNext()) {
                        Handler handler;
                        last = handler = (Handler)iterator.next();
                        log.info("* >> \u6267\u884c\uff1a {}", (Object)handler.taskDesc);
                        handler.getTask().apply();
                        log.info("* >> \u5b8c\u6210\uff1a {}", (Object)handler.taskDesc);
                    }
                    log.info("* <<<<<<<< \u4e8b\u52a1\u63d0\u4ea4\u524d\u7684\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
                }
                catch (RuntimeException e) {
                    log.error("* >> \u9519\u8bef\uff1a {} Exception: {}", new Object[]{last != null ? last.taskDesc : "unknown", e.getMessage(), e});
                    log.info("* <<<<<<<< \u4e8b\u52a1\u63d0\u4ea4\u524d\u7684\u4efb\u52a1\u6267\u884c\u7ec8\u6b62");
                    throw e;
                }
            }
            TransactionSync.unlock();
        }

        public void afterCommit() {
            TransactionSync.lock();
            List handlers = (List)tasksRunAfterCommit.get();
            if (handlers != null) {
                log.info("* >>>>>>>> \u51c6\u5907\u6267\u884c\u4e8b\u52a1\u63d0\u4ea4\u540e\u7684\u4efb\u52a1\uff0c\u4efb\u52a1\u6570\u91cf = {}", (Object)handlers.size());
                tasksRunAfterCommit.remove();
                for (Handler handler : handlers.stream().sorted().collect(Collectors.toList())) {
                    try {
                        log.info("* >> \u6267\u884c\uff1a {}", (Object)handler.taskDesc);
                        handler.getTask().apply();
                        log.info("* >> \u5b8c\u6210\uff1a {}", (Object)handler.taskDesc);
                    }
                    catch (Exception e) {
                        log.error("* >> \u9519\u8bef\uff1a {} Exception: {}", new Object[]{handler.taskDesc, e.getMessage(), e});
                    }
                }
                log.info("* <<<<<<<< \u4e8b\u52a1\u63d0\u4ea4\u540e\u7684\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            }
            TransactionSync.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                TransactionSync.lock();
                List handlers = (List)tasksRunAfterCompletion.get();
                if (handlers != null) {
                    log.info("* >>>>>>>> \u51c6\u5907\u6267\u884c\u4e8b\u52a1\u5b8c\u6210\u7684\u4efb\u52a1\uff0c\u4efb\u52a1\u6570\u91cf = {}", (Object)handlers.size());
                    tasksRunAfterCompletion.remove();
                    for (HandlerCompletion handler : handlers.stream().sorted().collect(Collectors.toList())) {
                        try {
                            log.info("* >> \u6267\u884c\uff1a {}", (Object)handler.taskDesc);
                            handler.getTask().apply(status);
                            log.info("* >> \u5b8c\u6210\uff1a {}", (Object)handler.taskDesc);
                        }
                        catch (Exception e) {
                            log.error("* >> \u9519\u8bef\uff1a {} Exception: {}", new Object[]{handler.taskDesc, e.getMessage(), e});
                        }
                    }
                    log.info("* <<<<<<<< \u4e8b\u52a1\u5b8c\u6210\u7684\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
                }
            }
            finally {
                TransactionSync.unlock();
                tasksRunBeforeCommit.remove();
                tasksRunAfterCommit.remove();
                tasksRunAfterCompletion.remove();
            }
        }
    };

    public static void runBeforeCommit(String taskDesc, Function t) {
        TransactionSync.run(taskDesc, t, System.currentTimeMillis(), tasksRunBeforeCommit);
    }

    public static void runAfterCommit(String taskDesc, Function t) {
        TransactionSync.run(taskDesc, t, System.currentTimeMillis(), tasksRunAfterCommit);
    }

    public static void runAfterCommitLast(String taskDesc, Function t) {
        TransactionSync.run(taskDesc, t, Long.MAX_VALUE - System.currentTimeMillis(), tasksRunAfterCommit);
    }

    public static void runAfterCompletion(String taskDesc, FunctionCompletion t) {
        TransactionSync.runAfterCompletion(taskDesc, t, System.currentTimeMillis());
    }

    public static void runAfterCompletionLast(String taskDesc, FunctionCompletion t) {
        TransactionSync.runAfterCompletion(taskDesc, t, Long.MAX_VALUE - System.currentTimeMillis());
    }

    private static void runAfterCompletion(String taskDesc, FunctionCompletion function, Long priority) {
        if (lock.get() != null) {
            throw new RuntimeException("\u4e8b\u52a1\u5df2\u7ecf\u5f00\u59cb\u63d0\u4ea4\uff0c\u4e0d\u80fd\u5d4c\u5957\u7ed1\u5b9a\u4efb\u52a1");
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            HandlerCompletion handler = new HandlerCompletion(taskDesc, function, priority);
            List<HandlerCompletion> handlers = tasksRunAfterCompletion.get();
            if (handlers == null) {
                handlers = new ArrayList<HandlerCompletion>();
                tasksRunAfterCompletion.set(handlers);
            }
            handlers.add(handler);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)transactionSync);
            if (log.isInfoEnabled()) {
                log.info("* \u7ed1\u5b9a\u4e8b\u52a1\u4efb\u52a1, \u4efb\u52a1\u5c06\u5728\u4e8b\u52a1\u5b8c\u6210\u540e\u6267\u884c, \u5f53\u524d\u4efb\u52a1\u6570\u91cf = {}", (Object)handlers.size());
                handlers.stream().sorted().forEach(h -> log.info("* -- {}", (Object)((HandlerCompletion)h).taskDesc));
            }
        } else {
            log.warn("* \u5f53\u524d\u7ebf\u7a0b\u65e0\u4e8b\u52a1\u7ba1\u7406\uff0c\u4efb\u52a1\u5c06\u7acb\u5373\u6267\u884c");
            try {
                function.apply(2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void run(String taskDesc, Function function, Long priority, ThreadLocal<List<Handler>> targetTaskList) {
        if (lock.get() != null) {
            throw new RuntimeException("\u670d\u52a1\u5df2\u7ecf\u5f00\u59cb\u6267\u884c\uff0c\u4e0d\u80fd\u5d4c\u5957\u4f7f\u7528");
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Handler handler = new Handler(taskDesc, function, priority);
            List<Handler> handlers = targetTaskList.get();
            if (handlers == null) {
                handlers = new ArrayList<Handler>();
                targetTaskList.set(handlers);
            }
            handlers.add(handler);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)transactionSync);
            if (log.isInfoEnabled()) {
                if (targetTaskList == tasksRunBeforeCommit) {
                    log.info("* \u7ed1\u5b9a\u4e8b\u52a1\u4efb\u52a1, \u4efb\u52a1\u5c06\u5728\u4e8b\u52a1\u63d0\u4ea4\u524d\u6267\u884c, \u5f53\u524d\u4efb\u52a1\u6570\u91cf = {}", (Object)handlers.size());
                } else {
                    log.info("* \u7ed1\u5b9a\u4e8b\u52a1\u4efb\u52a1, \u4efb\u52a1\u5c06\u5728\u4e8b\u52a1\u63d0\u4ea4\u540e\u6267\u884c, \u5f53\u524d\u4efb\u52a1\u6570\u91cf = {}", (Object)handlers.size());
                }
                handlers.stream().sorted().forEach(h -> log.info("* -- {}", (Object)((Handler)h).taskDesc));
            }
        } else {
            log.warn("* \u5f53\u524d\u7ebf\u7a0b\u65e0\u4e8b\u52a1\u7ba1\u7406\uff0c\u4efb\u52a1\u5c06\u7acb\u5373\u6267\u884c");
            try {
                function.apply();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void lock() {
        lock.set(true);
    }

    private static void unlock() {
        lock.remove();
    }

    @FunctionalInterface
    public static interface FunctionCompletion {
        public void apply(int var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Function {
        public void apply() throws Exception;
    }

    static class HandlerCompletion
    implements Comparable<HandlerCompletion> {
        private String taskDesc;
        private FunctionCompletion task;
        private Long priority;

        HandlerCompletion(String taskDesc, FunctionCompletion task, Long priority) {
            this.taskDesc = taskDesc;
            this.priority = priority;
            this.task = task;
        }

        FunctionCompletion getTask() {
            return this.task;
        }

        @Override
        public int compareTo(HandlerCompletion other) {
            return this.priority.compareTo(other.priority);
        }
    }

    static class Handler
    implements Comparable<Handler> {
        private String taskDesc;
        private Function task;
        private Long priority;

        Handler(String taskDesc, Function task, Long priority) {
            this.taskDesc = taskDesc;
            this.priority = priority;
            this.task = task;
        }

        Function getTask() {
            return this.task;
        }

        @Override
        public int compareTo(Handler other) {
            return this.priority.compareTo(other.priority);
        }
    }
}

