/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.basic;

import cn.nkpro.elcube.annotation.Keep;
import java.util.List;

@Keep
public class PageList<T> {
    private int page;
    private int rows;
    private long total;
    private int from;
    private int end;
    private long max;
    private List<T> list;

    public PageList(List<T> list, int from, int size, long total) {
        this.list = list;
        this.from = from;
        this.rows = size;
        this.page = size != 0 ? from / size + 1 : 1;
        this.total = total;
        this.max = size == 0 || total == 0L ? 0L : total / (long)size + (long)(total % (long)size == 0L ? 0 : 1);
        this.end = from + list.size() - 1;
    }

    public int getPage() {
        return this.page;
    }

    public int getRows() {
        return this.rows;
    }

    public long getTotal() {
        return this.total;
    }

    public int getFrom() {
        return this.from;
    }

    public int getEnd() {
        return this.end;
    }

    public long getMax() {
        return this.max;
    }

    public List<T> getList() {
        return this.list;
    }
}

