/*
 * This file is part of ELCube.
 *
 * ELCube is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ELCube is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with ELCube.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.nkpro.elcube.platform.gen;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PlatformRegistry extends PlatformRegistryKey implements Serializable {
    private String version;

    private Integer orderBy;

    /**
     * VALUE
     *
     * @mbggenerated
     */
    private String title;

    private String dataType;

    private Long updatedTime;

    private String updatedAccount;

    /**
     * VALUE
     *
     * @mbggenerated
     */
    private String content;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table nk_platform_registry
     *
     * @mbggenerated
     */
    private static final long serialVersionUID = 1L;

    @cn.nkpro.elcube.annotation.CodeFieldNotes("")
    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @cn.nkpro.elcube.annotation.CodeFieldNotes("")
    public Integer getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(Integer orderBy) {
        this.orderBy = orderBy;
    }

    /**
     * 获取 VALUE
     *
     * @return VALUE
     *
     * @mbggenerated
     */
    @cn.nkpro.elcube.annotation.CodeFieldNotes("VALUE")
    public String getTitle() {
        return title;
    }

    /**
     * 设置 VALUE
     *
     * @return VALUE
     *
     * @mbggenerated
     */
    public void setTitle(String title) {
        this.title = title;
    }

    @cn.nkpro.elcube.annotation.CodeFieldNotes("")
    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @cn.nkpro.elcube.annotation.CodeFieldNotes("")
    public Long getUpdatedTime() {
        return updatedTime;
    }

    public void setUpdatedTime(Long updatedTime) {
        this.updatedTime = updatedTime;
    }

    @cn.nkpro.elcube.annotation.CodeFieldNotes("")
    public String getUpdatedAccount() {
        return updatedAccount;
    }

    public void setUpdatedAccount(String updatedAccount) {
        this.updatedAccount = updatedAccount;
    }

    /**
     * 获取 VALUE
     *
     * @return VALUE
     *
     * @mbggenerated
     */
    @cn.nkpro.elcube.annotation.CodeFieldNotes("VALUE")
    public String getContent() {
        return content;
    }

    /**
     * 设置 VALUE
     *
     * @return VALUE
     *
     * @mbggenerated
     */
    public void setContent(String content) {
        this.content = content;
    }
}