/*
 * This file is part of ELCube.
 *
 * ELCube is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ELCube is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with ELCube.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.nkpro.elcube.co.fs.properties;

import lombok.Data;
import lombok.Getter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@Data
@ConfigurationProperties(prefix = "nk.huawei")
public class HuaweiProperties {

    private String accessKeyId;
    private String accessKeySecret;

    @NestedConfigurationProperty
    private OBS obs;

    @Data
    public static class OBS{
        @Getter
        private String bucket = "tfms";
        private String endpoint = "obs.cn-north-4.myhuaweicloud.com";
        private String host = "https://tfms.obs.cn-north-4.myhuaweicloud.com";
        /**
         * 上传到OSS的根目录路径，不能以/开头，必须以/结尾
         */
        private String path = "";
    }
}
