/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.components.pipeline.services;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.co.NkAsyncInvoker;
import cn.nkpro.elcube.co.http.NkHttpResponse;
import cn.nkpro.elcube.co.spel.NkAbstractHttpSpELInjection;
import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.exception.NkHttpException;
import cn.nkpro.elcube.exception.NkInputFailedCaution;
import cn.nkpro.elcube.security.SecurityUtilz;
import cn.nkpro.elcube.utils.DateTimeUtilz;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"nk.third.qcc.key", "nk.third.qcc.secretKey"})
@Component(value="SpELqcc")
public class NkSpELQcc
extends NkAbstractHttpSpELInjection {
    @Value(value="${nk.third.qcc.key}")
    private String key;
    @Value(value="${nk.third.qcc.secretKey}")
    private String secretKey;
    @Value(value="${nk.third.qcc.expire:86400}")
    private Long expire = 86400L;
    @Value(value="${nk.third.qcc.timeout:30}")
    private Integer timeout = 30;
    private String apiUrl = "http://api.qichacha.com";
    @Autowired
    private RedisSupport<JSONObject> redis;
    @Autowired
    private NkAsyncInvoker asyncInvoker;

    @NkNote(value="\u4f01\u67e5\u67e5-\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f", desc="@qcc.ECIComplement$GetInfo([searchKey])")
    public Object ECIComplement$GetInfo(String searchKey) {
        return this.get(String.format("/ECIComplement/GetInfo?searchKey=%s", searchKey));
    }

    @NkNote(value="\u4f01\u67e5\u67e5-949\u5f00\u6237\u5c3d\u804c\u8c03\u67e5\u5217\u8868", desc="@qcc.AcctScan$GetInfo([searchKey])")
    public Object AcctScan$GetInfo(String searchKey) {
        return this.get(String.format("/AcctScan/GetInfo?searchKey=%s", searchKey));
    }

    @NkNote(value="\u4f01\u67e5\u67e5-949\u4e25\u91cd\u8fdd\u6cd5\u5931\u4fe1\u8be6\u60c5", desc="@qcc.AcctScan$GetAcctSerVioDetail([detailId])")
    public Object AcctScan$GetAcctSerVioDetail(String detailId) {
        return this.get(String.format("/AcctScan/GetAcctSerVioDetail?id=%s", detailId));
    }

    public boolean isNotBlank(String str) {
        return StringUtils.isNotBlank((CharSequence)str) && !StringUtils.equalsAnyIgnoreCase((CharSequence)str, (CharSequence[])new CharSequence[]{"null", "undefined"});
    }

    public JSONObject get(String url) {
        return (JSONObject)this.redis.getIfAbsent(this.hashCode(url, null, null), this.expire.longValue(), true, () -> {
            String time = String.valueOf(DateTimeUtilz.nowSeconds());
            String token = DigestUtils.md5Hex((String)this.key.concat(time).concat(this.secretKey)).toUpperCase();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Token", token);
            headers.put("Timespan", time);
            String getUrl = this.apiUrl + url + (url.contains("?") ? (char)'&' : (char)'?') + "key=" + this.key;
            NkHttpResponse response = this.doGet(getUrl, headers);
            if (response.getStatusCode() == 200) {
                JSONObject responseJson = JSON.parseObject((String)response.getBody());
                switch (responseJson.getInteger("Status")) {
                    case 200: {
                        if (responseJson.containsKey((Object)"Paging")) {
                            JSONArray responseList = null;
                            Object result = responseJson.get((Object)"Result");
                            if (result instanceof JSONObject) {
                                result = ((JSONObject)result).getJSONArray("Data");
                            }
                            if (result instanceof JSONArray) {
                                responseList = (JSONArray)result;
                            }
                            if (responseList != null) {
                                JSONObject paging = responseJson.getJSONObject("Paging");
                                long totalRecords = paging.getLong("TotalRecords");
                                long pageSize = paging.getLong("PageSize");
                                long pageTotal = Math.min(totalRecords / pageSize + (long)(totalRecords % pageSize > 0L ? 1 : 0), 10L);
                                ArrayList<Future> futures = new ArrayList<Future>();
                                int i = 2;
                                while ((long)i <= pageTotal) {
                                    int finalPage = i++;
                                    futures.add(this.asyncInvoker.async(SecurityUtilz.getUser(), () -> JSON.parseObject((String)this.doGet(String.format("%s&pageIndex=%d", getUrl, finalPage), headers).getBody())));
                                }
                                JSONArray finalResponseList = responseList;
                                futures.forEach(future -> {
                                    try {
                                        JSONObject responsePaging = (JSONObject)future.get(this.timeout.intValue(), TimeUnit.SECONDS);
                                        if (responsePaging != null) {
                                            Object resultPaging = responsePaging.get((Object)"Result");
                                            if (resultPaging instanceof JSONObject) {
                                                resultPaging = ((JSONObject)resultPaging).getJSONArray("Data");
                                            }
                                            if (resultPaging instanceof JSONArray) {
                                                finalResponseList.addAll((Collection)((JSONArray)resultPaging));
                                            }
                                        }
                                    }
                                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                                        throw new NkHttpException(e.getMessage(), (Throwable)e);
                                    }
                                });
                            }
                        }
                        return responseJson;
                    }
                    case 201: {
                        return null;
                    }
                    case 202: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u67e5\u8be2\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
                    }
                    case 205: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u7b49\u5f85\u5904\u7406\u4e2d");
                    }
                    case 207: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u8bf7\u6c42\u6570\u636e\u7684\u6761\u76ee\u6570\u8d85\u8fc7\u4e0a\u9650\uff085000\uff09");
                    }
                    case 208: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u6b64\u63a5\u53e3\u4e0d\u652f\u6301\u6b64\u516c\u53f8\u7c7b\u578b\u67e5\u8be2");
                    }
                    case 209: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u4f01\u4e1a\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650");
                    }
                    case 213: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u53c2\u6570\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e2");
                    }
                    case 215: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u5173\u952e\u5b57");
                    }
                    case 218: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u8be5\u4f01\u4e1a\u6682\u4e0d\u652f\u6301\u7a7a\u58f3\u626b\u63cf");
                    }
                    case 219: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u8be5\u4f01\u4e1a\u6682\u4e0d\u652f\u6301\u5f00\u6237\u5c3d\u8c03");
                    }
                    case 105: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u63a5\u53e3\u5df2\u4e0b\u7ebf\u505c\u7528");
                    }
                    case 110: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u6709\u6548\u8bf7\u6c42\u3011\u5f53\u524d\u76f8\u540c\u67e5\u8be2\u8fde\u7eed\u51fa\u9519\uff0c\u8bf7\u7b492\u5c0f\u65f6\u540e\u91cd\u8bd5");
                    }
                    case 101: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u5f53\u524d\u7684KEY\u65e0\u6548\u6216\u8005\u8fd8\u672a\u751f\u6548\u4e2d");
                    }
                    case 102: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u5f53\u524dKEY\u5df2\u6b20\u8d39");
                    }
                    case 103: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u5f53\u524dKEY\u88ab\u6682\u505c\u4f7f\u7528");
                    }
                    case 104: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u8bf7\u6c42KEY\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    case 106: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u975e\u6cd5\u8bf7\u6c42\u8fc7\u591a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    case 107: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u88ab\u7981\u6b62\u7684IP\u6216\u8005\u7b7e\u540d\u9519\u8bef");
                    }
                    case 108: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u5f02\u5e38\u8bf7\u6c42\u8fc7\u591a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    case 109: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u8bf7\u6c42\u8d85\u8fc7\u6bcf\u65e5\u7cfb\u7edf\u9650\u5236");
                    }
                    case 111: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u63a5\u53e3\u6743\u9650\u672a\u5f00\u901a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    case 112: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u60a8\u7684\u8d26\u53f7\u5269\u4f59\u4f7f\u7528\u91cf\u5df2\u4e0d\u8db3\u6216\u5df2\u8fc7\u671f");
                    }
                    case 113: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u5f53\u524d\u63a5\u53e3\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7");
                    }
                    case 114: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u5f53\u524d\u63a5\u53e3\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    case 115: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u8eab\u4efd\u9a8c\u8bc1\u9519\u8bef\u6216\u8005\u5df2\u8fc7\u671f");
                    }
                    case 116: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u8bf7\u6c42\u8d85\u8fc7\u6bcf\u65e5\u8c03\u7528\u603b\u91cf\u9650\u5236");
                    }
                    case 117: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u5f53\u524d\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u53c2\u6570\u8c03\u7528\u91cf\u8fc7\u591a");
                    }
                    case 118: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u5f53\u524d\u63a5\u53e3\u4e0d\u652f\u6301\u6b64\u65b9\u5f0f\u7684\u8c03\u7528");
                    }
                    case 119: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u60a8\u7684\u5e10\u53f7\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    }
                    case 120: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u7cfb\u7edf\u6d41\u91cf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                    case 199: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u7cfb\u7edf\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u5ba2\u670d");
                    }
                    case 203: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u7cfb\u7edf\u67e5\u8be2\u6709\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458");
                    }
                    case 214: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u60a8\u8fd8\u672a\u8d2d\u4e70\u8fc7\u8be5\u63a5\u53e3\uff0c\u8bf7\u5148\u8d2d\u4e70");
                    }
                    case 223: {
                        throw new NkInputFailedCaution("\u4f01\u67e5\u67e5 -\u3010\u65e0\u6548\u8bf7\u6c42\u3011\u5f53\u524d\u63a5\u53e3\u7684\u8ba1\u8d39\u65b9\u5f0f\u4e0d\u652f\u6301\u6b64\u67e5\u8be2\u53c2\u6570");
                    }
                }
                throw new NkInputFailedCaution("\u4f01\u67e5\u67e5-\u672a\u77e5\u9519\u8bef\u8bf7\u6c42");
            }
            throw new NkInputFailedCaution("\u4f01\u67e5\u67e5-\u672a\u77e5\u9519\u8bef\u8bf7\u6c42");
        });
    }

    public JSONObject loopGet(String url, Object arrayParam) {
        Stream<Object> stream = null;
        if (arrayParam == null) {
            return null;
        }
        if (arrayParam instanceof Collection) {
            stream = ((Collection)arrayParam).stream().map(Object::toString);
        } else if (arrayParam.getClass().isArray()) {
            stream = Arrays.stream((String[])arrayParam);
        }
        assert (stream == null) : "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        String perName = stream.sorted().collect(Collectors.joining(","));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("perName", perName);
        return (JSONObject)this.redis.getIfAbsent(this.hashCode(url, null, param), this.expire.longValue(), true, () -> {
            JSONObject res = new JSONObject();
            JSONArray allInfo = new JSONArray();
            String[] perNames = perName.split(",");
            Arrays.stream(perNames).forEach(name -> {
                String time = String.valueOf(DateTimeUtilz.nowSeconds());
                String token = DigestUtils.md5Hex((String)this.key.concat(time).concat(this.secretKey)).toUpperCase();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Token", token);
                headers.put("Timespan", time);
                String getUrl = this.apiUrl + url + name + (url.contains("?") ? (char)'&' : (char)'?') + "key=" + this.key;
                NkHttpResponse response = this.doGet(getUrl, headers);
                JSONObject singleResponseJson = new JSONObject();
                singleResponseJson.put("name", name);
                if (response.getStatusCode() == 200) {
                    singleResponseJson = JSON.parseObject((String)response.getBody());
                    if (singleResponseJson.containsKey((Object)"Paging")) {
                        JSONArray responseList = null;
                        Object result = singleResponseJson.get((Object)"Result");
                        if (result instanceof JSONObject) {
                            result = ((JSONObject)result).getJSONArray("Data");
                        }
                        if (result instanceof JSONArray) {
                            responseList = (JSONArray)result;
                        }
                        if (responseList != null) {
                            JSONObject paging = singleResponseJson.getJSONObject("Paging");
                            long totalRecords = paging.getLong("TotalRecords");
                            long pageSize = paging.getLong("PageSize");
                            long pageTotal = Math.min(totalRecords / pageSize + (long)(totalRecords % pageSize > 0L ? 1 : 0), 10L);
                            ArrayList<Future> futures = new ArrayList<Future>();
                            int i = 2;
                            while ((long)i <= pageTotal) {
                                int finalPage = i++;
                                futures.add(this.asyncInvoker.async(SecurityUtilz.getUser(), () -> JSON.parseObject((String)this.doGet(String.format("%s&pageIndex=%d", getUrl, finalPage), headers).getBody())));
                            }
                            JSONArray finalResponseList = responseList;
                            futures.forEach(future -> {
                                try {
                                    JSONObject responsePaging = (JSONObject)future.get(this.timeout.intValue(), TimeUnit.SECONDS);
                                    if (responsePaging != null) {
                                        Object resultPaging = responsePaging.get((Object)"Result");
                                        if (resultPaging instanceof JSONObject) {
                                            resultPaging = ((JSONObject)resultPaging).getJSONArray("Data");
                                        }
                                        if (resultPaging instanceof JSONArray) {
                                            finalResponseList.addAll((Collection)((JSONArray)resultPaging));
                                        }
                                    }
                                }
                                catch (InterruptedException | ExecutionException | TimeoutException e) {
                                    throw new NkHttpException(e.getMessage(), (Throwable)e);
                                }
                            });
                            singleResponseJson.put("list", (Object)finalResponseList);
                            allInfo.add((Object)singleResponseJson);
                        }
                    }
                } else {
                    singleResponseJson.put("statusCode", (Object)response.getStatusCode());
                    singleResponseJson.put("list", null);
                    allInfo.add((Object)singleResponseJson);
                }
                res.put("results", (Object)allInfo);
            });
            return res;
        });
    }
}

