/*
 * This file is part of ELCube.
 *
 * ELCube is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ELCube is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with ELCube.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.nkpro.elcube.components.pipeline.cards

import cn.nkpro.elcube.annotation.NkNote
import cn.nkpro.elcube.co.spel.NkSpELManager
import cn.nkpro.elcube.docengine.EnumDocClassify
import cn.nkpro.elcube.docengine.NkAbstractCard
import cn.nkpro.elcube.docengine.model.DocDefIV
import cn.nkpro.elcube.docengine.model.DocHV
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.core.annotation.Order
import org.springframework.stereotype.Component

@Order(2002)
@NkNote("标签打分表")
@Component("NkCardPipelineScoreSheet")
class NkCardPipelineScoreSheet extends NkAbstractCard<List<Score>,Def> {

    @Override
    boolean supports(String classify) {
        return classify == EnumDocClassify.PIPELINE.name()
    }

    @Autowired
    private NkSpELManager spELManager

    @Override
    List<Score> calculate(DocHV doc, List<Score> data, DocDefIV defIV, Def d, boolean isTrigger, Object options) {


        data.clear()
        if(d.rules){
            d.rules.forEach({ rule ->

                def context = spELManager.createContext(doc)
                Object value = rule.valueSpEL?spELManager.invoke(rule.valueSpEL,context):null
                context.setVariable("value", value)
                Double score = rule.scoreSpEL?(spELManager.invoke(rule.scoreSpEL,context) as Double):null
                context.setVariable("score", score)

                if(value!=null||score!=null){

                    Score s = new Score()
                    s.key = rule.key
                    s.name = rule.name
                    s.value = value
                    s.score = score
                    s.finalScore = score ? score * (rule.weight?:1) : null
                    s.output = rule.outputSpEL?spELManager.invoke(rule.outputSpEL,context):null

                    data.add(s)
                }
            })
        }

        return data
    }

    static class Def implements Serializable{
        List<Rule> rules
    }

    static class Rule implements Serializable{
        String key
        String name
        String valueSpEL
        String scoreSpEL
        Double weight
        String desc
        String outputSpEL
    }

    static class Score implements Serializable{
        String key
        String name
        Double score
        Object value
        Double finalScore
        String output
    }
}
