/*
 * This file is part of ELCube.
 *
 * ELCube is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ELCube is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with ELCube.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.nkpro.elcube.components.pipeline.cards

import cn.nkpro.elcube.annotation.NkNote
import cn.nkpro.elcube.co.NkAsyncInvoker
import cn.nkpro.elcube.co.spel.NkSpELManager
import cn.nkpro.elcube.docengine.EnumDocClassify
import cn.nkpro.elcube.docengine.NkAbstractCard
import cn.nkpro.elcube.docengine.model.DocDefIV
import cn.nkpro.elcube.docengine.model.DocHV
import cn.nkpro.elcube.docengine.model.DocPipeline
import cn.nkpro.elcube.exception.NkSystemException
import com.alibaba.fastjson.JSON
import org.apache.commons.lang3.StringUtils
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.core.annotation.Order
import org.springframework.expression.EvaluationContext
import org.springframework.stereotype.Component

import java.util.concurrent.Future
import java.util.concurrent.TimeUnit
import java.util.stream.Collectors

@Order(2003)
@NkNote("数据展示")
@Component("NkCardPipelineDataViewer")
class NkCardPipelineDataViewer extends NkAbstractCard<Map,Def> {

    @Override
    boolean supports(String classify) {
        return classify == EnumDocClassify.PIPELINE.name()
    }
    @Autowired
    private NkSpELManager spELManager

    @Override
    boolean independentStore() {
        return true
    }

    @Override
    Map afterGetData(DocHV doc, Map data, DocDefIV defIV, Def d) {
        if(doc.isViewed()){
            if(d.contextSpEL){
                data.put("context",spELManager.invoke(d.contextSpEL, doc))
            }
        }
        return super.afterGetData(doc, data, defIV, d) as Map
    }

    @Override
    Map calculate(DocHV doc, Map data, DocDefIV defIV, Def d, boolean isTrigger, Object options) {
        if(doc.isViewed()){
            if(d.contextSpEL){
                data.put("context",spELManager.invoke(d.contextSpEL, doc))
            }
        }
        return super.calculate(doc, data, defIV, d, isTrigger, options) as Map
    }

    @Override
    Map afterUpdated(DocHV doc, Map data, Map original, DocDefIV defIV, Def d) {
        if(doc.isViewed()){
            if(d.contextSpEL){
                data.put("context",spELManager.invoke(d.contextSpEL, doc))
            }
        }
        return super.afterUpdated(doc, data, original, defIV, d) as Map
    }

    static class Def implements Serializable{
        String contextSpEL
        String vueTemplate
    }
}
