/*
 * This file is part of ELCube.
 *
 * ELCube is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ELCube is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with ELCube.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.nkpro.elcube.components.pipeline.cards

import cn.nkpro.elcube.annotation.NkNote
import cn.nkpro.elcube.co.spel.NkSpELManager
import cn.nkpro.elcube.docengine.EnumDocClassify
import cn.nkpro.elcube.docengine.NkAbstractCard
import cn.nkpro.elcube.docengine.model.DocDefIV
import cn.nkpro.elcube.docengine.model.DocHV
import cn.nkpro.elcube.docengine.model.DocPipeline
import com.alibaba.fastjson.JSON
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.core.annotation.Order
import org.springframework.stereotype.Component
import org.springframework.util.Assert

@Order(2003)
@NkNote("列表结果")
@Component("NkCardPipelineListResult")
class NkCardPipelineListResult extends NkAbstractCard<List,Def> {

    @Override
    boolean supports(String classify) {
        return classify == EnumDocClassify.PIPELINE.name()
    }

    @Override
    protected String[] getDefComponentNames() {
        return [ "NkCardPipelineResultDef" ]
    }
    @Autowired
    private NkSpELManager spELManager

    @Override
    List afterGetData(DocHV doc, List data, DocDefIV defIV, Def d) {
        if(doc instanceof DocPipeline && d.resultSpEL){
            doc.getResults().put("list", data)
        }
        return super.afterGetData(doc, data, defIV, d) as List
    }

    @Override
    List calculate(DocHV doc, List data, DocDefIV defIV, Def d, boolean isTrigger, Object options) {
        if(doc instanceof DocPipeline && d.resultSpEL){
            Object list = JSON.parse(spELManager.convert(d.resultSpEL, spELManager.createContext(doc)))
            Assert.isTrue(list instanceof Collection,"结果表达式必须返回一个Collection实例")
            data = list as List
            doc.getResults().put("list", data)
        }
        return super.calculate(doc, data, defIV, d, isTrigger, options) as List
    }

    static class Def implements Serializable{
        String resultSpEL
    }
}
