/*
 * This file is part of ELCube.
 *
 * ELCube is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ELCube is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with ELCube.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.nkpro.elcube.components.defaults.taskFields

import cn.nkpro.elcube.annotation.NkNote
import cn.nkpro.elcube.task.from.NkAbstractFormFieldType
import cn.nkpro.elcube.task.model.BpmFormField
import org.camunda.bpm.engine.task.Task
import org.camunda.bpm.engine.variable.value.TypedValue
import org.springframework.stereotype.Component

@NkNote("工作流单据引用")
@Component("NkTaskFieldRef")
class NkTaskFieldRef extends NkAbstractFormFieldType {

    @Override
    TypedValue convertToFormValue(TypedValue typedValue) {
        return typedValue
    }

    @Override
    TypedValue convertToModelValue(TypedValue typedValue) {
        return typedValue
    }

    @Override
    Object convertFormValueToModelValue(Object o) {
        return o
    }

    @Override
    String convertModelValueToFormValue(Object o) {
        return o!=null?o.toString():null
    }

    @Override
    void doPreprocess(BpmFormField field, Task task){

    }
}
