/*
 * This file is part of ELCube.
 *
 * ELCube is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ELCube is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with ELCube.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.nkpro.elcube.components.defaults.services

import cn.nkpro.elcube.annotation.NkNote
import cn.nkpro.elcube.docengine.NkDocEngine
import cn.nkpro.elcube.docengine.gen.DocDefFlow
import cn.nkpro.elcube.docengine.interceptor.abstracts.NkAbstractDocFlowInterceptor
import cn.nkpro.elcube.docengine.model.DocHV
import cn.nkpro.elcube.docengine.service.impl.NkDocFinder
import com.alibaba.fastjson.JSON
import org.apache.commons.lang3.StringUtils
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

/**
 * 根据后续单据数量，来判断能否创建当前后续
 *
 * docType  后续单据类型，null 表示所有单据类型
 * docState 后续单据类型的状态，null 表示所有单据状态
 *
 * 如果存在满足 docType 和 docState 条件的单据，则不允许继续当前后续
 *
 */
@NkNote("限制模型只能创建一个后续单据")
@SuppressWarnings("unused")
@Component("NkFollowUpDocFlowInterceptor")
class NkFollowUpDocFlowInterceptor
        extends NkAbstractDocFlowInterceptor{

    @Autowired
    NkDocEngine docEngine

    @Override
    FlowDescribe apply(DocHV docHV, DocDefFlow flow) {
        if(StringUtils.isBlank(flow.getRefObjectParams())){
            return FlowDescribe.invisible("参数配置错误")
        }

        Param param = JSON.parseObject(flow.getRefObjectParams(),Param.class)

        // 构建一个查询
        NkDocFinder finder = docEngine
                .find(param.docType?:new String[0])
                .prevIdEquals(docHV.docId)
        if(param.docState!=null&&param.docState.length>0)
            finder.docStateIn(param.docState)

        if(finder.countResult() == 0){
            return FlowDescribe.visible()
        }

        return FlowDescribe.invisible("已存在后续单据")
    }

    static class Param{
        String[] docType
        String[] docState
    }
}
