/*
 * This file is part of ELCube.
 *
 * ELCube is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ELCube is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with ELCube.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.nkpro.elcube.components.defaults.fields

import cn.nkpro.elcube.annotation.NkNote
import cn.nkpro.elcube.co.easy.EasySingle
import cn.nkpro.elcube.docengine.NkUpLoadField
import cn.nkpro.elcube.docengine.NkAbstractField
import cn.nkpro.elcube.docengine.cards.NkDynamicFormDefI
import cn.nkpro.elcube.docengine.cards.NkDynamicFormField
import cn.nkpro.elcube.docengine.cards.NkDynamicGridField
import org.springframework.core.annotation.Order
import org.springframework.expression.EvaluationContext
import org.springframework.stereotype.Component

@Order(90)
@NkNote("文件")
@Component("NkFieldFileUpload")
class NkFieldFileUpload extends NkAbstractField implements NkDynamicFormField, NkDynamicGridField, NkUpLoadField {

    @Override
    void beforeUpdate(NkDynamicFormDefI field, EvaluationContext context, EasySingle card) {
        Map<String,String> item = card.get(field.key)
        if(item)
            item.entrySet()
                .removeIf({ e -> !(e.key == 'name' || e.key == 'path' || e.key == 'uid') })
    }

    /**
     * 获取文件的path
     * @param field
     * @param context
     * @param card
     * @return
     */
    @Override
    List<String> getFilesPath(NkDynamicFormDefI field, EasySingle card) {
        Map<String,String> item = card.get(field.key)
        List<String> pathList = new ArrayList<>();
        if(item){
            pathList.add((String)item.get("path"))
        }
        return pathList;
    }
}
