/*
 * This file is part of ELCube.
 *
 * ELCube is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ELCube is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with ELCube.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.nkpro.elcube.components.defaults.cards

import cn.nkpro.elcube.annotation.NkNote
import cn.nkpro.elcube.data.elasticearch.ESPageList
import cn.nkpro.elcube.docengine.NkAbstractCard
import cn.nkpro.elcube.docengine.NkDocEngine
import cn.nkpro.elcube.docengine.NkDocSearchService
import cn.nkpro.elcube.docengine.model.DocDefIV
import cn.nkpro.elcube.docengine.model.DocHV
import cn.nkpro.elcube.docengine.model.SearchParams
import com.alibaba.fastjson.JSONObject
import org.apache.catalina.filters.AddDefaultCharsetFilter
import org.elasticsearch.index.query.QueryBuilders
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.core.annotation.Order
import org.springframework.stereotype.Component

@Order(1010)
@NkNote("交易历史")
@Component("NkCardTransactionHistories")
class NkCardTransactionHistories extends NkAbstractCard<Map,Map> {

    @Autowired
    NkDocEngine docEngine

    @Autowired
    NkDocSearchService docSearchService

    @Override
    Object call(DocHV doc, Map data, DocDefIV defIV, Map d, Object options) {

        ESPageList<JSONObject> total = docSearchService.queryList(
                null,
                "{\"term\":{\"refObjectId\":\""+doc.getRefObjectId()+"\"}}",
                SearchParams.defaults(0)
        )
        if(total.total<=200){
            return docSearchService.queryList(
                    null,
                    "{\"term\":{\"refObjectId\":\""+doc.getRefObjectId()+"\"}}",
                    SearchParams.defaults(200)
                            .order("createdTime", true)
            )
        }

        ESPageList<JSONObject> page = docSearchService.queryList(
                null,
                "{" +
                "   \"bool\":{                                                              " +
                "      \"should\":[{                                                        " +
                "           \"terms\":{                                                     " +
                "               \"docId\":[\"${doc.getPreDocId()}\",\"${doc.getDocId()}\"]  " +
                "           }                                                               " +
                "       },                                                                  " +
                "       {                                                                   " +
                "           \"term\":{                                                      " +
                "               \"preDocId\":\"${doc.getDocId()}\"                          " +
                "           }                                                               " +
                "       }]                                                                  " +
                "   }                                                                       " +
                "}",
//                QueryBuilders.boolQuery()
//                        .should(QueryBuilders.termsQuery("docId",doc.getPreDocId(),doc.getDocId()))
//                        .should(QueryBuilders.termQuery("preDocId",doc.getDocId())),
                SearchParams.defaults(202)
                        .order("createdTime", true)
        )

        return new ESPageList(page.list, page.aggs,page.suggests,page.from,page.rows,total.total)
    }
}
