/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.wsdoc;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.wsdoc.ReturnTypeAnalyser;
import cn.nkpro.elcube.wsdoc.WsConstant;
import cn.nkpro.elcube.wsdoc.model.Ctrl;
import cn.nkpro.elcube.wsdoc.model.Fun;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Controller
@RequestMapping(value={"/wsdoc"})
public class WsDocAngularController
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Class<Object> ctrlType = Object.class;
    @Value(value="${spring.application.name}")
    private String applicationName;

    @ResponseBody
    @RequestMapping(value={""}, produces={"text/html;charset=UTF-8"})
    public String _default() {
        return "<script>location.href='wsdoc/index.html';</script>";
    }

    @ResponseBody
    @RequestMapping(value={"/controllers"})
    public List<Ctrl> controllers() {
        HashMap beans = new HashMap();
        beans.putAll(this.applicationContext.getBeansWithAnnotation(Controller.class));
        beans.putAll(this.applicationContext.getBeansWithAnnotation(RestController.class));
        return beans.entrySet().stream().filter(entry -> ClassUtils.getUserClass(entry.getValue()).isAnnotationPresent(NkNote.class)).map(entry -> {
            Class controllerType = ClassUtils.getUserClass(entry.getValue());
            NkNote nkController = controllerType.getAnnotation(NkNote.class);
            Ctrl ctrlConfig = new Ctrl();
            ctrlConfig.setBeanName((String)entry.getKey());
            ctrlConfig.setCtrlName(nkController.value());
            ctrlConfig.setCtrlDesc(nkController.desc());
            ctrlConfig.setFuncs(this.methods(controllerType));
            return ctrlConfig;
        }).sorted().collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"/controller/{beanName}"})
    public Ctrl controller(@PathVariable(value="beanName") String beanName) {
        Object ctrl = this.applicationContext.getBean(beanName, this.ctrlType);
        Class controllerType = ClassUtils.getUserClass((Object)ctrl);
        NkNote ctrlNote = controllerType.getAnnotation(NkNote.class);
        Ctrl ctrlConfig = new Ctrl();
        ctrlConfig.setBeanName(beanName);
        ctrlConfig.setCtrlName(ctrlNote != null ? ctrlNote.value() : controllerType.getName());
        ctrlConfig.setCtrlDesc(ctrlNote != null ? ctrlNote.desc() : "");
        ctrlConfig.setFuncs(this.methods(controllerType));
        return ctrlConfig;
    }

    private List<Fun> methods(Class<?> controllerType) {
        RequestMapping ctrlRequestMapping = controllerType.getAnnotation(RequestMapping.class);
        String ctrlMappingURL = ctrlRequestMapping != null ? ctrlRequestMapping.value()[0] : "";
        return Arrays.stream(controllerType.getMethods()).filter(method -> method.getAnnotation(RequestMapping.class) != null || method.getAnnotation(GetMapping.class) != null || method.getAnnotation(PostMapping.class) != null).map(method -> {
            Fun methodConfig = new Fun();
            String mapping = this.GetMethodMapping((Method)method);
            NkNote methodNote = method.getAnnotation(NkNote.class);
            methodConfig.setFuncName(methodNote != null ? methodNote.value() : mapping);
            methodConfig.setFuncMapping(method.getName() + "@" + mapping.replaceAll("[/.]", "!"));
            methodConfig.setFuncUrl(ctrlMappingURL + mapping);
            return methodConfig;
        }).sorted().collect(Collectors.toList());
    }

    private String GetMethodMapping(Method method) {
        String[] mappings = this.GetMethodMappings(method);
        return mappings != null && mappings.length > 0 ? mappings[0] : "";
    }

    private String[] GetMethodMappings(Method method) {
        RequestMapping methodRequestMapping = method.getAnnotation(RequestMapping.class);
        if (methodRequestMapping != null) {
            return methodRequestMapping.value();
        }
        GetMapping methodGetMapping = method.getAnnotation(GetMapping.class);
        if (methodGetMapping != null) {
            return methodGetMapping.value();
        }
        PostMapping methodPostMapping = method.getAnnotation(PostMapping.class);
        if (methodPostMapping != null) {
            return methodPostMapping.value();
        }
        PutMapping methodPutMapping = method.getAnnotation(PutMapping.class);
        if (methodPutMapping != null) {
            return methodPutMapping.value();
        }
        DeleteMapping methodDeleteMapping = method.getAnnotation(DeleteMapping.class);
        if (methodDeleteMapping != null) {
            return methodDeleteMapping.value();
        }
        PatchMapping methodPatchMapping = method.getAnnotation(PatchMapping.class);
        if (methodPatchMapping != null) {
            return methodPatchMapping.value();
        }
        return null;
    }

    @ResponseBody
    @RequestMapping(value={"/controller/{beanName}/{funcMapping}"})
    public Map<String, Object> method(@PathVariable(value="beanName") String beanName, @PathVariable(value="funcMapping") String funcMapping) {
        String methodUrl;
        String[] funcMappings = funcMapping.split("[@]");
        String funcMappings0 = funcMappings[0];
        String funcMappings1 = funcMappings.length > 1 ? funcMappings[1] : "";
        Object ctrl = this.applicationContext.getBean(beanName, this.ctrlType);
        Method method = Arrays.stream(ClassUtils.getUserClass((Object)ctrl).getMethods()).filter(item -> {
            if (!item.getName().equals(funcMappings0)) {
                return false;
            }
            String[] mappings = this.GetMethodMappings((Method)item);
            return mappings != null && Arrays.stream(mappings).anyMatch(m -> m.replaceAll("[/.]", "!").equals(funcMappings1));
        }).findFirst().orElse(null);
        if (method == null) {
            return null;
        }
        Class controllerType = ClassUtils.getUserClass((Object)ctrl);
        RequestMapping ctrlRequestMapping = controllerType.getAnnotation(RequestMapping.class);
        String ctrlMappingURL = ctrlRequestMapping != null ? ctrlRequestMapping.value()[0] : "";
        HashMap<String, Object> methodConfig = new HashMap<String, Object>();
        RequestMapping methodRequestMapping = method.getAnnotation(RequestMapping.class);
        if (methodRequestMapping != null) {
            methodUrl = methodRequestMapping.value()[0];
            if (methodRequestMapping.method().length == 0) {
                methodConfig.put("method", "GET|POST");
            } else {
                StringBuilder builder = new StringBuilder();
                for (RequestMethod m : methodRequestMapping.method()) {
                    builder.append('|');
                    builder.append(m.name());
                }
                if (builder.length() > 0) {
                    builder.deleteCharAt(0);
                }
                methodConfig.put("method", builder);
            }
        } else {
            GetMapping methodGetMapping = method.getAnnotation(GetMapping.class);
            if (methodGetMapping != null) {
                methodUrl = methodGetMapping.value()[0];
                methodConfig.put("method", "GET");
            } else {
                PostMapping methodPostMapping = method.getAnnotation(PostMapping.class);
                methodUrl = methodPostMapping.value()[0];
                methodConfig.put("method", "POST");
            }
        }
        NkNote methodNote = method.getAnnotation(NkNote.class);
        methodConfig.put("url", ctrlMappingURL + methodUrl);
        if (methodNote != null) {
            methodConfig.put("notes", methodNote.value());
            methodConfig.put("desc", methodNote.desc());
            methodConfig.put("warn", methodNote.warn());
            methodConfig.put("dependentEnums", Arrays.stream(methodNote.dependentEnums()).map(clazz -> {
                NkNote codeNotes = clazz.getAnnotation(NkNote.class);
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("name", codeNotes == null ? clazz.getSimpleName() : codeNotes.value());
                m.put("type", clazz.getSimpleName());
                m.put("items", Arrays.stream((WsConstant[])clazz.getEnumConstants()).map(item -> item).collect(Collectors.toMap(WsConstant::getCode, WsConstant::getDesc, (a, b) -> b, LinkedHashMap::new)));
                return m;
            }).collect(Collectors.toList()));
            methodConfig.put("retur", methodNote.retur());
            methodConfig.put("returContent", ReturnTypeAnalyser.analyse(method.getReturnType(), 1, null).trim());
        }
        methodConfig.put("deprecated", method.getAnnotation(Deprecated.class));
        methodConfig.put("isResponseBody", method.getAnnotation(ResponseBody.class) != null);
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions.length > 0) {
            ArrayList exceptionConfigs = new ArrayList();
            for (Class<?> exception : exceptions) {
                NkNote eNotes = exception.getAnnotation(NkNote.class);
                if (eNotes == null) continue;
                HashMap<String, String> exceptionConfig = new HashMap<String, String>();
                exceptionConfig.put("code", eNotes.value());
                exceptionConfig.put("desc", eNotes.desc());
                exceptionConfigs.add(exceptionConfig);
            }
            if (!exceptionConfigs.isEmpty()) {
                methodConfig.put("exceptions", exceptionConfigs);
            }
        }
        ArrayList methodParams = new ArrayList();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Class<?>[] types = method.getParameterTypes();
        HashMap<String, Object> paramConfig = null;
        for (int i = 0; i < types.length; ++i) {
            Class<?> type;
            Annotation[] annos;
            for (Annotation anno : annos = parameterAnnotations[i]) {
                if (anno.annotationType() == RequestParam.class) {
                    paramConfig = new HashMap<String, Object>();
                    RequestParam rp = (RequestParam)anno;
                    paramConfig.put("paramType", "RequestParam");
                    paramConfig.put("name", rp.value());
                    Class<?> type2 = types[i];
                    if (type2.isArray()) {
                        paramConfig.put("type", type2.getComponentType().getName() + "[]");
                    } else {
                        paramConfig.put("type", type2.getName());
                    }
                    paramConfig.put("required", rp.required());
                }
                if (anno.annotationType() == PathVariable.class) {
                    paramConfig = new HashMap();
                    PathVariable pv = (PathVariable)anno;
                    paramConfig.put("paramType", "PathVariable");
                    paramConfig.put("type", String.class.getName());
                    paramConfig.put("name", "{" + pv.value() + "}");
                    paramConfig.put("required", true);
                }
                if (anno.annotationType() != RequestBody.class) continue;
                paramConfig = new HashMap();
                paramConfig.put("name", "@RequestBody");
                paramConfig.put("paramType", "RequestBody");
                type = types[i];
                if (type.isArray()) {
                    paramConfig.put("type", type.getComponentType().getName() + "[]");
                } else {
                    paramConfig.put("type", type.getName());
                }
                paramConfig.put("required", true);
                paramConfig.put("bodyFormat", ReturnTypeAnalyser.analyse(type));
            }
            for (Annotation anno : annos) {
                if (anno.annotationType() != NkNote.class) continue;
                if (paramConfig == null) {
                    paramConfig = new HashMap();
                    paramConfig.put("paramType", "Undefined");
                    type = types[i];
                    if (type.isArray()) {
                        paramConfig.put("type", type.getComponentType().getName() + "[]");
                    } else {
                        paramConfig.put("type", type.getName());
                    }
                    paramConfig.put("name", "{ Unknow }");
                    paramConfig.put("required", false);
                }
                NkNote c = (NkNote)anno;
                paramConfig.put("notes", c.value());
            }
            if (paramConfig != null) {
                methodParams.add(paramConfig);
            }
            paramConfig = null;
        }
        methodConfig.put("params", methodParams);
        return methodConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

