/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.wsdoc;

import cn.nkpro.elcube.annotation.CodeFieldListNotes;
import cn.nkpro.elcube.annotation.CodeFieldNotes;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReturnTypeAnalyser {
    public static String analyse(Class<?> clazz) {
        return ReturnTypeAnalyser.execAnalyse(new HashSet<Class>(), clazz, 0, null);
    }

    public static String analyse(Class<?> clazz, int level, String desc) {
        return ReturnTypeAnalyser.execAnalyse(new HashSet<Class>(), clazz, level, desc);
    }

    private static String execAnalyse(Set<Class> hash, Class<?> clazz, int level, String desc) {
        Method[] methods;
        StringBuilder buf = new StringBuilder();
        if (clazz.getName().startsWith("com.alibaba.fastjson")) {
            buf.append("<").append(clazz.getName()).append(">");
            return buf.toString();
        }
        if (clazz.getName().startsWith("org.springframework")) {
            buf.append("<").append(clazz.getName()).append(">");
            return buf.toString();
        }
        if (clazz == Void.TYPE || clazz == Void.class) {
            buf.append("<Void>");
            if (desc != null) {
                buf.append(desc);
            }
            return buf.toString();
        }
        if (clazz == Class.class || clazz == Object.class) {
            if (desc != null) {
                buf.append(desc);
            }
            return buf.toString();
        }
        if (ReturnTypeAnalyser.isBasicType(clazz)) {
            buf.append(ReturnTypeAnalyser.makeLevel(level));
            buf.append("(").append(clazz.getName()).append(") ");
            return buf.toString();
        }
        if (ReturnTypeAnalyser.isImplements(clazz, Collection.class)) {
            Type type = clazz.getGenericSuperclass();
            if (type == null) {
                buf.append(ReturnTypeAnalyser.makeLevel(level));
                buf.append("[ <List> ]");
                return buf.toString();
            }
            buf.append("[");
            buf.append('\n');
            buf.append(ReturnTypeAnalyser.execAnalyse(hash, type.getClass(), level + 2, desc));
            buf.append('\n');
            buf.append("] ");
            return buf.toString();
        }
        if (ReturnTypeAnalyser.isImplements(clazz, Map.class)) {
            Type type = clazz.getGenericSuperclass();
            if (type == null) {
                buf.append(ReturnTypeAnalyser.makeLevel(level));
                buf.append("{ <Map> }");
                return buf.toString();
            }
            Type[] types = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
            buf.append(ReturnTypeAnalyser.makeLevel(level));
            buf.append("{");
            buf.append('\n');
            buf.append(ReturnTypeAnalyser.makeLevel(level + 1));
            buf.append("<KEY> :");
            buf.append(ReturnTypeAnalyser.execAnalyse(hash, (Class)types[0], level + 2, desc));
            buf.append('\n');
            buf.append(ReturnTypeAnalyser.makeLevel(level + 1));
            buf.append("<VALUE> :");
            buf.append(ReturnTypeAnalyser.execAnalyse(hash, (Class)types[1], level + 2, desc));
            buf.append('\n');
            buf.append(ReturnTypeAnalyser.makeLevel(level));
            buf.append("} ");
            return buf.toString();
        }
        if (clazz.isArray()) {
            buf.append("[");
            buf.append('\n');
            buf.append(ReturnTypeAnalyser.execAnalyse(hash, clazz.getComponentType(), level + 2, desc));
            buf.append('\n');
            buf.append("] ");
            return buf.toString();
        }
        if (desc != null) {
            buf.append(ReturnTypeAnalyser.makeLevel(level));
            buf.append("//").append(desc);
            buf.append('\n');
        }
        buf.append(ReturnTypeAnalyser.makeLevel(level));
        buf.append('{');
        buf.append('\n');
        if (hash.contains(clazz)) {
            hash.add(clazz);
            return buf.toString();
        }
        hash.add(clazz);
        for (Method method : methods = clazz.getMethods()) {
            String bufSub;
            Class<?> returnType;
            if (!method.getName().startsWith("get") || method.getName().length() <= 3 || (returnType = method.getReturnType()) == Class.class) continue;
            if (ReturnTypeAnalyser.isBasicType(returnType)) {
                buf.append(ReturnTypeAnalyser.makeBuf(level + 1, method, ReturnTypeAnalyser.makeFieldDesc(method)));
                continue;
            }
            if (ReturnTypeAnalyser.isImplements(returnType, Map.class)) {
                buf.append(ReturnTypeAnalyser.makeBuf(level + 1, method, ReturnTypeAnalyser.makeFieldDesc(method)));
                continue;
            }
            if (ReturnTypeAnalyser.isImplements(returnType, Collection.class)) {
                CodeFieldListNotes bgn = method.getAnnotation(CodeFieldListNotes.class);
                if (bgn != null) {
                    bufSub = "[\n" + ReturnTypeAnalyser.execAnalyse(hash, bgn.componentType(), level + 2, bgn.value()) + '\n' + ReturnTypeAnalyser.makeLevel(level + 1) + ']';
                    buf.append(ReturnTypeAnalyser.makeBuf(level + 1, method, bufSub));
                    continue;
                }
                buf.append(ReturnTypeAnalyser.makeBuf(level + 1, method, ReturnTypeAnalyser.makeFieldDesc(method)));
                continue;
            }
            if (ReturnTypeAnalyser.isArray(returnType)) {
                String d = null;
                CodeFieldNotes cfn = method.getAnnotation(CodeFieldNotes.class);
                CodeFieldListNotes cfln = method.getAnnotation(CodeFieldListNotes.class);
                if (cfn != null) {
                    d = cfn.value();
                } else if (cfln != null) {
                    d = cfln.value();
                }
                String bufSub2 = "[\n" + ReturnTypeAnalyser.execAnalyse(hash, returnType.getComponentType(), level + 2, d) + '\n' + ReturnTypeAnalyser.makeLevel(level + 1) + ']';
                buf.append(ReturnTypeAnalyser.makeBuf(level + 1, method, bufSub2));
                continue;
            }
            CodeFieldNotes cfn = method.getAnnotation(CodeFieldNotes.class);
            bufSub = '\n' + ReturnTypeAnalyser.execAnalyse(hash, returnType, level + 2, cfn != null ? cfn.value() : "");
            buf.append(ReturnTypeAnalyser.makeBuf(level + 1, method, bufSub));
        }
        buf.append(ReturnTypeAnalyser.makeLevel(level));
        buf.append('}');
        return buf.toString();
    }

    private static String makeFieldDesc(Method method) {
        CodeFieldNotes cfn = method.getAnnotation(CodeFieldNotes.class);
        return method.getReturnType().getSimpleName() + " " + (cfn != null ? cfn.value() : "");
    }

    private static String makeBuf(int level, Method method, String desc) {
        return ReturnTypeAnalyser.makeLevel(level) + '\"' + method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4) + "\" : " + desc + '\n';
    }

    private static String makeLevel(int level) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            buf.append("  ");
        }
        return buf.toString();
    }

    private static boolean isArray(Class<?> res) {
        return res.isArray();
    }

    private static boolean isImplements(Class<?> res, Class<?> interfaceClass) {
        Class<?>[] interfaces;
        if (res == interfaceClass) {
            return true;
        }
        for (Class<?> i : interfaces = res.getInterfaces()) {
            if (i != interfaceClass) continue;
            return true;
        }
        if (res.getSuperclass() != null) {
            return ReturnTypeAnalyser.isImplements(res.getSuperclass(), interfaceClass);
        }
        return false;
    }

    private static boolean isBasicType(Class<?> res) {
        if (res.getPackage() == Integer.class.getPackage()) {
            return true;
        }
        ArrayList<Class<BigDecimal>> valueTypes = new ArrayList<Class<BigDecimal>>();
        valueTypes.add(BigDecimal.class);
        return valueTypes.contains(res);
    }
}

