/*
 * Decompiled with CFR 0.152.
 */
package cn.nikeo.permisos.compiler;

import com.google.auto.common.MoreTypes;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.TypeNames;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\f\u00a8\u0006\u0017"}, d2={"Lcn/nikeo/permisos/compiler/Processors;", "", "()V", "getAnnotationMirrorOptional", "Ljava/util/Optional;", "Ljavax/lang/model/element/AnnotationMirror;", "element", "Ljavax/lang/model/element/Element;", "className", "Lcom/squareup/kotlinpoet/ClassName;", "getEnclosedClassName", "getEnclosedName", "", "name", "hasAnnotation", "", "isAssignableFrom", "Ljavax/lang/model/element/TypeElement;", "isAssignableFromAnyOf", "classNames", "Lcom/google/common/collect/ImmutableSet;", "prepend", "prefix", "permisos-compiler"})
public final class Processors {
    public static final Processors INSTANCE;

    private final String getEnclosedName(ClassName name) {
        String string = Joiner.on((char)'_').join((Iterable)name.getSimpleNames());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Joiner.on('_').join(name.simpleNames)");
        return string;
    }

    @NotNull
    public final ClassName getEnclosedClassName(@NotNull ClassName className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return new ClassName(className.getPackageName(), new String[]{this.getEnclosedName(className)});
    }

    @NotNull
    public final ClassName prepend(@NotNull ClassName name, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return name.peerClass(prefix + name.getSimpleName());
    }

    public final boolean isAssignableFrom(@NotNull TypeElement element, @NotNull ClassName className) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        ImmutableSet immutableSet = ImmutableSet.of((Object)className);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"ImmutableSet.of(className)");
        return this.isAssignableFromAnyOf(element, (ImmutableSet<ClassName>)immutableSet);
    }

    private final boolean isAssignableFromAnyOf(TypeElement element, ImmutableSet<ClassName> classNames) {
        TypeMirror superClass;
        for (ClassName className : classNames) {
            if (!Intrinsics.areEqual((Object)ClassNames.get((TypeElement)element), (Object)className)) continue;
            return true;
        }
        TypeMirror typeMirror = superClass = element.getSuperclass();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"superClass");
        if (typeMirror.getKind() != TypeKind.NONE && superClass.getKind() != TypeKind.ERROR) {
            Preconditions.checkState((superClass.getKind() == TypeKind.DECLARED ? 1 : 0) != 0);
            TypeElement typeElement = MoreTypes.asTypeElement((TypeMirror)superClass);
            Intrinsics.checkNotNullExpressionValue((Object)typeElement, (String)"MoreTypes.asTypeElement(superClass)");
            if (this.isAssignableFromAnyOf(typeElement, classNames)) {
                return true;
            }
        }
        Iterator<? extends TypeMirror> iterator = element.getInterfaces().iterator();
        while (iterator.hasNext()) {
            TypeMirror iface;
            TypeMirror typeMirror2 = iface = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"iface");
            if (typeMirror2.getKind() == TypeKind.ERROR) continue;
            Preconditions.checkState((iface.getKind() == TypeKind.DECLARED ? 1 : 0) != 0, (String)"Interface type is %s", (Object)((Object)iface.getKind()));
            TypeElement typeElement = MoreTypes.asTypeElement((TypeMirror)iface);
            Intrinsics.checkNotNullExpressionValue((Object)typeElement, (String)"MoreTypes.asTypeElement(iface)");
            if (!this.isAssignableFromAnyOf(typeElement, classNames)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAnnotation(@NotNull Element element, @NotNull ClassName className) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this.getAnnotationMirrorOptional(element, className).isPresent();
    }

    private final Optional<AnnotationMirror> getAnnotationMirrorOptional(Element element, ClassName className) {
        Object r = element.getAnnotationMirrors().stream().filter((Predicate)new Predicate<AnnotationMirror>(className){
            final /* synthetic */ ClassName $className;

            public final boolean test(@NotNull AnnotationMirror mirror) {
                Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
                DeclaredType declaredType = mirror.getAnnotationType();
                Intrinsics.checkNotNullExpressionValue((Object)declaredType, (String)"mirror.annotationType");
                return Intrinsics.areEqual((Object)TypeNames.get((TypeMirror)declaredType), (Object)this.$className);
            }
            {
                this.$className = className;
            }
        }).collect(MoreCollectors.toOptional());
        Intrinsics.checkNotNullExpressionValue(r, (String)"element.annotationMirror\u2026   .collect(toOptional())");
        return (Optional)r;
    }

    private Processors() {
    }

    static {
        Processors processors;
        INSTANCE = processors = new Processors();
    }
}

