/*
 * Decompiled with CFR 0.152.
 */
package cn.nikeo.permisos.compiler;

import cn.nikeo.permisos.compiler.AnnotationValues;
import com.google.auto.common.MoreElements;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlinx.metadata.Flag;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.KmConstructorVisitor;
import kotlinx.metadata.KmValueParameterVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.annotations.NotNull;

public final class KotlinMetadata {
    private final KotlinClassMetadata.Class metadata;
    private final TypeElement typeElement;
    private final int flags;

    private KotlinMetadata(KotlinClassMetadata.Class metadata, TypeElement typeElement, int flags) {
        this.metadata = metadata;
        this.typeElement = typeElement;
        this.flags = flags;
    }

    public boolean isObjectClass() {
        return Flag.Class.IS_OBJECT.invoke(this.flags);
    }

    public boolean isCompanionObjectClass() {
        return Flag.Class.IS_COMPANION_OBJECT.invoke(this.flags);
    }

    public boolean containsConstructorWithDefaultParam() {
        final boolean[] containsDefaultParam = new boolean[]{false};
        this.metadata.accept(new KmClassVisitor(){
            private final KmConstructorVisitor constructorVisitor = new KmConstructorVisitor(){

                public KmValueParameterVisitor visitValueParameter(int flags, @NotNull String name) {
                    containsDefaultParam[0] = containsDefaultParam[0] | Flag.ValueParameter.DECLARES_DEFAULT_VALUE.invoke(flags);
                    return super.visitValueParameter(flags, name);
                }
            };

            public KmConstructorVisitor visitConstructor(int flags) {
                return this.constructorVisitor;
            }
        });
        return containsDefaultParam[0];
    }

    public static Optional<KotlinMetadata> of(TypeElement typeElement) {
        if (!MoreElements.isAnnotationPresent((Element)typeElement, Metadata.class)) {
            return Optional.empty();
        }
        KotlinClassMetadata.Class metadata = KotlinMetadata.metadataOf(typeElement);
        MetadataVisitor visitor = new MetadataVisitor();
        metadata.accept((KmClassVisitor)visitor);
        return Optional.of(new KotlinMetadata(metadata, typeElement, visitor.classFlags));
    }

    private static KotlinClassMetadata.Class metadataOf(TypeElement typeElement) {
        AnnotationMirror metadataAnnotation = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)typeElement, Metadata.class).get();
        KotlinClassHeader header = new KotlinClassHeader(Integer.valueOf(AnnotationValues.getIntValue(metadataAnnotation, "k")), AnnotationValues.getIntArrayValue(metadataAnnotation, "mv"), AnnotationValues.getIntArrayValue(metadataAnnotation, "bv"), AnnotationValues.getStringArrayValue(metadataAnnotation, "d1"), AnnotationValues.getStringArrayValue(metadataAnnotation, "d2"), AnnotationValues.getStringValue(metadataAnnotation, "xs"), (String)AnnotationValues.getOptionalStringValue(metadataAnnotation, "pn").orElse(null), (Integer)AnnotationValues.getOptionalIntValue(metadataAnnotation, "xi").orElse(null));
        KotlinClassMetadata metadata = KotlinClassMetadata.read((KotlinClassHeader)header);
        if (metadata == null) {
            throw new IllegalStateException("Unsupported metadata version. Check that your Kotlin version is >= 1.0");
        }
        if (metadata instanceof KotlinClassMetadata.Class) {
            return (KotlinClassMetadata.Class)metadata;
        }
        throw new IllegalStateException("Unsupported metadata type: " + metadata);
    }

    private static final class MetadataVisitor
    extends KmClassVisitor {
        int classFlags;

        private MetadataVisitor() {
        }

        public void visit(int flags, @NotNull String s) {
            this.classFlags = flags;
        }
    }
}

