/*
 * Decompiled with CFR 0.152.
 */
package cn.nikeo.permisos.compiler;

import cn.nikeo.permisos.compiler.AndroidClassNames;
import cn.nikeo.permisos.compiler.ClassNames;
import cn.nikeo.permisos.compiler.Generators;
import cn.nikeo.permisos.compiler.PermisosMetadata;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.TypeSpec;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcn/nikeo/permisos/compiler/ActivityGenerator;", "", "env", "Ljavax/annotation/processing/ProcessingEnvironment;", "metadata", "Lcn/nikeo/permisos/compiler/PermisosMetadata;", "(Ljavax/annotation/processing/ProcessingEnvironment;Lcn/nikeo/permisos/compiler/PermisosMetadata;)V", "generatedClassName", "Lcom/squareup/kotlinpoet/ClassName;", "generate", "", "permisos-compiler"})
public final class ActivityGenerator {
    private final ClassName generatedClassName;
    private final ProcessingEnvironment env;
    private final PermisosMetadata metadata;

    public final void generate() throws IOException {
        KModifier[] kModifierArray = this.metadata.generatedClassModifiers();
        TypeSpec.Builder builder = ((TypeSpec.Builder)TypeSpec.Companion.classBuilder(this.generatedClassName).addOriginatingElement((Element)this.metadata.getElement())).superclass(this.metadata.getBaseClassName()).addKdoc("An activity with the ability to easily check and request dangerous permissions.\n\n@see [https://developer.android.com/training/permissions/requesting]", new Object[0]).addModifiers(Arrays.copyOf(kModifierArray, kModifierArray.length));
        Generators.INSTANCE.addRequireActivityProperty(this.metadata.getAndroidType(), builder);
        Generators.INSTANCE.addPermissionsCheckerAndImplementation(builder);
        Generators.INSTANCE.addPermissionConfiguration(builder);
        Generators.INSTANCE.addOnRequestPermissionsResultFunOverride(builder);
        FileSpec fileSpec = FileSpec.Companion.builder(this.generatedClassName.getPackageName(), this.generatedClassName.getSimpleName()).addComment("Generated file. Do not edit!", new Object[0]).addImport(AndroidClassNames.INSTANCE.getPACKAGE_MANAGER().getPackageName(), new String[]{AndroidClassNames.INSTANCE.getPACKAGE_MANAGER().getSimpleName()}).addImport(AndroidClassNames.INSTANCE.getCALL_SUPER().getPackageName(), new String[]{AndroidClassNames.INSTANCE.getCALL_SUPER().getSimpleName()}).addImport(AndroidClassNames.INSTANCE.getACTIVITY_COMPAT().getPackageName(), new String[]{AndroidClassNames.INSTANCE.getACTIVITY_COMPAT().getSimpleName()}).addImport(ClassNames.INSTANCE.getPERMISSION_TYPE().getPackageName(), new String[]{ClassNames.INSTANCE.getPERMISSION_TYPE().getSimpleName()}).addImport(ClassNames.INSTANCE.getGROUP_PERMISSIONS().getPackageName(), new String[]{ClassNames.INSTANCE.getGROUP_PERMISSIONS().getSimpleName()}).addType(builder.build()).build();
        Filer filer = this.env.getFiler();
        Intrinsics.checkNotNullExpressionValue((Object)filer, (String)"env.filer");
        fileSpec.writeTo(filer);
    }

    public ActivityGenerator(@NotNull ProcessingEnvironment env, @NotNull PermisosMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = this.metadata.getGeneratedClassName();
    }
}

