/*
 * Decompiled with CFR 0.152.
 */
package cn.nextop.gadget.etcd.support.watcher.impl;

import cn.nextop.gadget.etcd.grpc.WatchRequest;
import cn.nextop.gadget.etcd.grpc.WatchResponse;
import cn.nextop.gadget.etcd.support.watcher.WatchListener;
import cn.nextop.gadget.etcd.support.watcher.Watcher;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class WatcherImpl<T>
implements StreamObserver<WatchResponse>,
Watcher<T> {
    private WatchRequest request;
    private WatchListener<T> listener;
    private Function<WatchResponse, T> mapper;
    private StreamObserver<WatchRequest> observer;

    @Override
    public WatchRequest getRequest() {
        return this.request;
    }

    @Override
    public WatchListener<T> getListener() {
        return this.listener;
    }

    @Override
    public Function<WatchResponse, T> getMapper() {
        return this.mapper;
    }

    @Override
    public StreamObserver<WatchRequest> getObserver() {
        return this.observer;
    }

    public void setRequest(WatchRequest request) {
        this.request = request;
    }

    public void setListener(WatchListener<T> listener) {
        this.listener = listener;
    }

    public void setMapper(Function<WatchResponse, T> mapper) {
        this.mapper = mapper;
    }

    public void setObserver(StreamObserver<WatchRequest> observer) {
        this.observer = observer;
    }

    public void onCompleted() {
    }

    @Override
    public void close() throws Exception {
        this.observer.onCompleted();
    }

    public void onNext(WatchResponse wr) {
        CompletableFuture<T> future = new CompletableFuture<T>();
        future.complete(this.mapper.apply(wr));
        this.listener.onWatched(future);
    }

    public void onError(Throwable trx) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(trx);
        this.listener.onWatched(future);
    }
}

