/*
 * Decompiled with CFR 0.152.
 */
package cn.nextop.gadget.etcd.support.util;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class Strings {
    public static int length(String s) {
        return s == null ? 0 : s.length();
    }

    public static String lower(String s) {
        return s == null ? null : s.toLowerCase();
    }

    public static String upper(String s) {
        return s == null ? null : s.toUpperCase();
    }

    public static String add(String ... s) {
        if (s == null) {
            return "";
        }
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            r.append(s[i]);
        }
        return r.toString();
    }

    public static boolean between(String s, int min, int max) {
        int v = Strings.length(s);
        return min <= v && v <= max;
    }

    public static String trim(String s) {
        return s == null ? null : s.trim();
    }

    public static String trimToNull(String s) {
        return Strings.isEmpty(s = Strings.trim(s)) ? null : s;
    }

    public static String trimToEmpty(String s) {
        return s == null ? "" : s.trim();
    }

    public static String trim(String s, char c) {
        return Strings.rtrim(Strings.ltrim(s, c), c);
    }

    public static String trim(String s, int max) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() > max) {
            s = s.substring(0, max);
        }
        return s;
    }

    public static String ltrim(String s, char trim) {
        int i;
        if (s == null) {
            return null;
        }
        int length = s.length();
        for (i = 0; i < length && s.charAt(i) == trim; ++i) {
        }
        return i >= s.length() ? "" : s.substring(i);
    }

    public static String rtrim(String s, char trim) {
        int i;
        if (s == null) {
            return null;
        }
        for (i = s.length() - 1; i >= 0 && s.charAt(i) == trim; --i) {
        }
        return i < 0 ? "" : s.substring(0, i + 1);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(String s, boolean trim) {
        if (s == null) {
            return true;
        }
        return trim ? s.trim().length() == 0 : s.length() == 0;
    }

    public static boolean isEquals(String s1, String s2) {
        return Strings.isEquals(s1, s2, false);
    }

    public static boolean isEquals(String s1, String s2, boolean ic) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return ic ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
    }

    public static boolean isEquals(String s1, String s2, String ... strs) {
        if (Strings.isEquals(s1, s2)) {
            return true;
        }
        if (strs == null) {
            return false;
        }
        for (int i = 0; i < strs.length; ++i) {
            if (!Strings.isEquals(s1, strs[i])) continue;
            return true;
        }
        return false;
    }

    public static String toString(Object o) {
        return o == null ? "" : o.toString();
    }

    public static String[] toArray(String s) {
        String[] stringArray;
        if (s == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        }
        return stringArray;
    }

    public static String[] toArray(String ... s) {
        return s;
    }

    public static String toString(Object[] array) {
        return Strings.toString(array, array.length);
    }

    public static String toString(byte[] array, int length) {
        StringBuilder r = new StringBuilder("[");
        int count = Math.min(length, array.length);
        for (int i = 0; i < count; ++i) {
            r.append(array[i]);
            if (i >= count - 1) continue;
            r.append(",");
        }
        r.append("]");
        return r.toString();
    }

    public static String toString(int[] array, int length) {
        StringBuilder r = new StringBuilder("[");
        int count = Math.min(length, array.length);
        for (int i = 0; i < count; ++i) {
            r.append(array[i]);
            if (i >= count - 1) continue;
            r.append(",");
        }
        r.append("]");
        return r.toString();
    }

    public static String toString(long[] array, int length) {
        StringBuilder r = new StringBuilder("[");
        int count = Math.min(length, array.length);
        for (int i = 0; i < count; ++i) {
            r.append(array[i]);
            if (i >= count - 1) continue;
            r.append(",");
        }
        r.append("]");
        return r.toString();
    }

    public static String toString(Object[] array, int length) {
        StringBuilder r = new StringBuilder("[");
        int count = Math.min(length, array.length);
        for (int i = 0; i < count; ++i) {
            r.append(array[i]);
            if (i >= count - 1) continue;
            r.append(",");
        }
        r.append("]");
        return r.toString();
    }

    public static final String lappend(int src, int length, char padding) {
        return Strings.lappend(String.valueOf(src), length, padding);
    }

    public static final String rappend(int src, int length, char padding) {
        return Strings.rappend(String.valueOf(src), length, padding);
    }

    public static final String lappend(String src, int length, char padding) {
        if (src != null && src.length() >= length) {
            return src;
        }
        src = src == null ? "" : src;
        StringBuilder r = new StringBuilder(length);
        for (int i = src.length(); i < length; ++i) {
            r.append(padding);
        }
        r.append(src);
        return r.toString();
    }

    public static final String rappend(String src, int length, char padding) {
        if (src != null && src.length() >= length) {
            return src;
        }
        src = src == null ? "" : src;
        StringBuilder r = new StringBuilder(length);
        r.append(src);
        for (int i = src.length(); i < length; ++i) {
            r.append(padding);
        }
        return r.toString();
    }

    public static ToStringBuilder build(Object obj) {
        return new ToStringBuilder(obj, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static ToStringBuilder build(Object obj, String toString) {
        return new ToStringBuilder(obj, ToStringStyle.SHORT_PREFIX_STYLE).appendToString(toString);
    }

    public static String buildEx(Object obj) {
        return ToStringBuilder.reflectionToString((Object)obj, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

