/*
 * Decompiled with CFR 0.152.
 */
package cn.nextop.gadget.etcd.support.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public final class Objects {
    public static final Object NULL = new Object();
    public static final Object[] EMPTY = new Object[0];
    private static final Set<Class<?>> IMMUTABLE_CLASSES = new HashSet();
    private static final Set<Class<?>> PRIMITIVES_AND_WRAPPERS;

    public static boolean registerImmutableClass(Class<?> clazz) {
        return IMMUTABLE_CLASSES.add(clazz);
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static boolean isEquals(Object lhs, Object rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        return lhs.equals(rhs);
    }

    public static boolean isArray(Object array) {
        if (array == null) {
            return false;
        }
        return array.getClass().isArray();
    }

    public static boolean isSerializable(Object obj) {
        return obj instanceof Serializable;
    }

    public static boolean isPrimitiveOrWrapper(Object obj) {
        if (obj == null) {
            return false;
        }
        return PRIMITIVES_AND_WRAPPERS.contains(obj.getClass());
    }

    public static boolean isArrayOfPrimitives(Object array) {
        if (array == null) {
            return false;
        }
        Class<?> clazz = array.getClass();
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isArrayOfPrimitivesOrWrappers(Object array) {
        if (array == null) {
            return false;
        }
        Class<?> clazz = array.getClass();
        return clazz.isArray() && PRIMITIVES_AND_WRAPPERS.contains(clazz);
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz == null || !clazz.isPrimitive()) {
            return null;
        }
        if (Void.TYPE == clazz) {
            return null;
        }
        if (Boolean.TYPE == clazz) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE == clazz) {
            return (byte)0;
        }
        if (Short.TYPE == clazz) {
            return (short)0;
        }
        if (Integer.TYPE == clazz) {
            return 0;
        }
        if (Long.TYPE == clazz) {
            return 0L;
        }
        if (Character.TYPE == clazz) {
            return Character.valueOf('\u0000');
        }
        if (Double.TYPE == clazz) {
            return 0.0;
        }
        if (Float.TYPE == clazz) {
            return Float.valueOf(0.0f);
        }
        throw new RuntimeException("assertion failed, should not reach here, clazz: " + clazz);
    }

    static {
        IMMUTABLE_CLASSES.add(Boolean.class);
        IMMUTABLE_CLASSES.add(Byte.class);
        IMMUTABLE_CLASSES.add(Character.class);
        IMMUTABLE_CLASSES.add(Double.class);
        IMMUTABLE_CLASSES.add(Float.class);
        IMMUTABLE_CLASSES.add(Integer.class);
        IMMUTABLE_CLASSES.add(Long.class);
        IMMUTABLE_CLASSES.add(Short.class);
        IMMUTABLE_CLASSES.add(Class.class);
        IMMUTABLE_CLASSES.add(String.class);
        IMMUTABLE_CLASSES.add(BigDecimal.class);
        IMMUTABLE_CLASSES.add(BigInteger.class);
        PRIMITIVES_AND_WRAPPERS = new HashSet();
        PRIMITIVES_AND_WRAPPERS.add(Boolean.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Boolean.class);
        PRIMITIVES_AND_WRAPPERS.add(Byte.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Byte.class);
        PRIMITIVES_AND_WRAPPERS.add(Character.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Character.class);
        PRIMITIVES_AND_WRAPPERS.add(Double.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Double.class);
        PRIMITIVES_AND_WRAPPERS.add(Float.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Float.class);
        PRIMITIVES_AND_WRAPPERS.add(Integer.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Integer.class);
        PRIMITIVES_AND_WRAPPERS.add(Long.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Long.class);
        PRIMITIVES_AND_WRAPPERS.add(Short.TYPE);
        PRIMITIVES_AND_WRAPPERS.add(Short.class);
    }
}

