/*
 * Decompiled with CFR 0.152.
 */
package cn.nextop.gadget.etcd.support.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Lists {
    public static <T> List<T> emptyList() {
        return Collections.EMPTY_LIST;
    }

    public static int size(List<?> v) {
        return v == null ? 0 : v.size();
    }

    public static void clear(List<?> list) {
        if (list != null) {
            list.clear();
        }
    }

    public static boolean isEmpty(List<?> values) {
        return values == null || values.isEmpty();
    }

    public static <T> List<T> nullToEmpty(List<T> list) {
        return list != null ? list : Lists.emptyList();
    }

    public static <T> Iterable<T> iterable(List<T> list) {
        return Lists.isEmpty(list) ? Lists.emptyList() : list;
    }

    public static <T> List<T> fill(int size, T t) {
        ArrayList<T> r = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            r.add(t);
        }
        return r;
    }

    public static <T> List<T> trim(List<T> v, int size) {
        int n = Lists.size(v);
        if (n <= size) {
            return v;
        }
        for (int i = n - 1; i >= size; --i) {
            v.remove(i);
        }
        return v;
    }

    public static <T> List<T> toList(T ... values) {
        if (values == null) {
            return new ArrayList(0);
        }
        ArrayList<T> r = new ArrayList<T>(values.length);
        for (T value : values) {
            r.add(value);
        }
        return r;
    }

    public static <T> List<T> toList(T value) {
        ArrayList r = new ArrayList(1);
        Lists.add(r, value);
        return r;
    }

    public static <T> List<T> toList(Collection<? extends T> vs) {
        return vs == null ? new ArrayList(0) : new ArrayList<T>(vs);
    }

    public static final <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> r = new ArrayList<T>();
        if (iterator == null) {
            return r;
        }
        while (iterator.hasNext()) {
            r.add(iterator.next());
        }
        return r;
    }

    public static <T> boolean add(List<T> list, T v) {
        if (list != null && v != null) {
            return list.add(v);
        }
        return false;
    }

    public static final <T> T get(List<T> value, int index) {
        return value == null || index >= value.size() ? null : (T)value.get(index);
    }

    public static final <T> List<T> dels(Collection<T> a, Collection<T> b) {
        ArrayList<T> r = new ArrayList<T>(a);
        if (b != null) {
            r.removeAll(b);
        }
        return r;
    }

    public static <T> List<T> adds(List<? extends T> v1, List<? extends T> v2) {
        List<T> r = Lists.toList(v1);
        if (v2 != null) {
            r.addAll(v2);
        }
        return r;
    }

    public static <T> List<T> reverse(List<T> list) {
        if (list == null) {
            return null;
        }
        Collections.reverse(list);
        return list;
    }

    public static <T extends Comparable<? super T>> List<T> sort(List<T> list) {
        if (list == null) {
            return null;
        }
        Collections.sort(list);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        if (list == null) {
            return null;
        }
        Collections.sort(list, c);
        return list;
    }
}

