/*
 * Decompiled with CFR 0.152.
 */
package cn.nextop.gadget.etcd.support.resolver.impl.uri;

import cn.nextop.gadget.etcd.EtcdException;
import cn.nextop.gadget.etcd.support.resolver.URIResolver;
import cn.nextop.gadget.etcd.support.util.Exceptions;
import cn.nextop.gadget.etcd.support.util.Lists;
import cn.nextop.gadget.etcd.support.util.Objects;
import cn.nextop.gadget.etcd.support.util.Strings;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class DnsSrvUriResolver
implements URIResolver {
    private static final List<String> SCHEMES = Lists.toList(new String[]{"dns+srv", "dnssrv", "srv"});
    private Hashtable<String, String> env;
    private Comparator<SocketAddress> comparator;
    private String[] attributes = new String[]{"SRV"};

    public void setComparator(Comparator<SocketAddress> v) {
        this.comparator = v;
    }

    public DnsSrvUriResolver() {
        this.env = new Hashtable();
        this.env.put("java.naming.provider.url", "dns:");
        this.env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        this.comparator = (v1, v2) -> v1.toString().compareTo(v2.toString());
    }

    @Override
    public boolean supports(URI uri) {
        return SCHEMES.contains(uri.getScheme());
    }

    @Override
    public List<SocketAddress> resolve(URI uri) {
        if (!this.supports(uri)) {
            throw new EtcdException(String.valueOf(uri));
        }
        try {
            String authority = uri.getAuthority();
            ArrayList list = new ArrayList();
            InitialDirContext context = new InitialDirContext(this.env);
            Comparator<SocketAddress> cmp = this.comparator;
            Attributes attributes = context.getAttributes(authority, this.attributes);
            NamingEnumeration it = (NamingEnumeration)Objects.cast(attributes.get("srv").getAll());
            while (it.hasMore()) {
                Lists.add(list, DnsSrvUriResolver.resolve((String)it.next()));
            }
            return Lists.sort(list, cmp);
        }
        catch (Throwable tx) {
            EtcdException e = new EtcdException(Exceptions.getRootCause(tx));
            throw e;
        }
    }

    protected static final InetSocketAddress resolve(String address) {
        String[] ary = address.split(" ");
        if (ary.length < 4) {
            return null;
        }
        return new InetSocketAddress(Strings.trimToEmpty(ary[3]), Integer.parseInt(Strings.trimToEmpty(ary[2])));
    }
}

