/*
 * Decompiled with CFR 0.152.
 */
package cn.nextop.gadget.etcd.support.resolver.impl;

import cn.nextop.gadget.etcd.EtcdException;
import cn.nextop.gadget.etcd.support.resolver.URIResolver;
import cn.nextop.gadget.etcd.support.resolver.impl.AbstractNameResolver;
import cn.nextop.gadget.etcd.support.resolver.impl.uri.DirectUriResolver;
import cn.nextop.gadget.etcd.support.resolver.impl.uri.DnsSrvUriResolver;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SmartNameResolver
extends AbstractNameResolver {
    private final List<URIResolver> resolvers = new CopyOnWriteArrayList<URIResolver>();

    public SmartNameResolver(String a, Collection<URI> u) {
        super(a, u);
        this.resolvers.add(new DirectUriResolver());
        this.resolvers.add(new DnsSrvUriResolver());
    }

    public void addResolvers(List<URIResolver> resolvers) {
        this.resolvers.addAll(resolvers);
    }

    public void delResolvers(List<URIResolver> resolvers) {
        this.resolvers.removeAll(resolvers);
    }

    @Override
    protected void doResolve(NameResolver.Listener listener) {
        try {
            ArrayList<EquivalentAddressGroup> list = new ArrayList<EquivalentAddressGroup>();
            for (URI uri : this.uris) {
                this.doResolve(uri, list);
            }
            if (list.isEmpty()) {
                throw new EtcdException("resolve");
            }
            listener.onAddresses(list, Attributes.EMPTY);
            this.listeners.onAddresses(list, Attributes.EMPTY);
        }
        catch (Throwable e) {
            listener.onError(Status.NOT_FOUND);
            this.listeners.onError(Status.NOT_FOUND);
        }
    }

    protected void doResolve(URI u, List<EquivalentAddressGroup> list) {
        for (URIResolver r : this.resolvers) {
            if (!r.supports(u)) continue;
            list.add(new EquivalentAddressGroup(r.resolve(u)));
        }
    }
}

