/*
 * Decompiled with CFR 0.152.
 */
package cn.nextop.gadget.etcd.support.resolver.impl;

import cn.nextop.gadget.etcd.support.resolver.NameResolverListeners;
import io.grpc.NameResolver;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.Executor;

public abstract class AbstractNameResolver
extends NameResolver {
    protected Executor executor;
    protected NameResolver.Listener listener;
    protected final String authority;
    protected volatile boolean shutdown;
    protected volatile boolean resolving;
    protected final Collection<URI> uris;
    protected NameResolverListeners listeners;

    protected abstract void doResolve(NameResolver.Listener var1);

    public AbstractNameResolver(String a, Collection<URI> u) {
        this.authority = a;
        this.uris = u;
        this.listeners = new NameResolverListeners();
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public synchronized void refresh() {
        this.resolve();
    }

    public boolean addListener(NameResolver.Listener listener) {
        return this.listeners.addListener(listener);
    }

    public boolean delListener(NameResolver.Listener listener) {
        return this.listeners.delListener(listener);
    }

    public synchronized void start(NameResolver.Listener r) {
        this.executor = (Executor)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        this.listener = r;
        this.resolve();
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.executor != null) {
            this.executor = (Executor)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR, (Object)this.executor);
        }
    }

    protected void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(new XRunnable());
    }

    protected class XRunnable
    implements Runnable {
        protected XRunnable() {
        }

        @Override
        public void run() {
            if (AbstractNameResolver.this.shutdown || AbstractNameResolver.this.resolving) {
                return;
            }
            AbstractNameResolver.this.resolving = true;
            NameResolver.Listener r = AbstractNameResolver.this.listener;
            try {
                AbstractNameResolver.this.doResolve(r);
            }
            finally {
                AbstractNameResolver.this.resolving = false;
            }
        }
    }
}

