/*
 * Decompiled with CFR 0.152.
 */
package cn.nextop.gadget.etcd.support.resolver;

import cn.nextop.gadget.etcd.EtcdException;
import cn.nextop.gadget.etcd.support.resolver.URIResolver;
import cn.nextop.gadget.etcd.support.resolver.impl.SmartNameResolver;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class NameResolverFactory
extends NameResolver.Factory {
    private static final String ETCD = "etcd";
    private final String[] uris;
    private NameResolver.Listener listener;
    private final List<URIResolver> resolvers;

    public NameResolverFactory(String[] uris) {
        this.uris = uris;
        this.resolvers = new CopyOnWriteArrayList<URIResolver>();
    }

    public String getDefaultScheme() {
        return ETCD;
    }

    public void addResolver(URIResolver r) {
        this.resolvers.add(r);
    }

    public void delResolver(URIResolver r) {
        this.resolvers.remove(r);
    }

    public NameResolver.Listener getListener() {
        return this.listener;
    }

    public void setListener(NameResolver.Listener listener) {
        this.listener = listener;
    }

    public NameResolver newNameResolver(URI uri, Attributes attributes) {
        if (!ETCD.equals(uri.getScheme())) {
            return null;
        }
        List<URI> list = Arrays.stream(this.uris).map(this::uri).collect(Collectors.toList());
        SmartNameResolver r = new SmartNameResolver(ETCD, list);
        if (this.listener != null) {
            r.addListener(this.listener);
        }
        r.addResolvers(this.resolvers);
        return r;
    }

    private URI uri(String uri) {
        try {
            return new URI(uri);
        }
        catch (Throwable e) {
            throw new EtcdException(e);
        }
    }
}

