/*
 * Decompiled with CFR 0.152.
 */
package cn.nextop.gadget.etcd.support.future;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class CompletableFutureEx<T>
extends CompletableFuture<T> {
    private final ListenableFuture<T> future;

    public CompletableFutureEx(ListenableFuture<T> future) {
        this.future = future;
        Futures.addCallback(this.future, (FutureCallback)new CallbackEx(), (Executor)new ExecutorEx());
    }

    @Override
    public boolean cancel(boolean v) {
        boolean r = this.future.cancel(v) && super.cancel(v);
        return r;
    }

    private class CallbackEx
    implements FutureCallback<T> {
        private CallbackEx() {
        }

        public void onSuccess(T v) {
            CompletableFutureEx.this.complete(v);
        }

        public void onFailure(Throwable t) {
            CompletableFutureEx.this.completeExceptionally(t);
        }
    }

    private class ExecutorEx
    implements Executor {
        private ExecutorEx() {
        }

        @Override
        public void execute(Runnable v) {
            v.run();
        }
    }
}

