package org.jsmth.faker;

import org.jsmth.util.ValueUtil;

import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by mason on 2018/2/2.
 */
public class RegionItem {
    int id = 0;
    int pid = 0;
    int level = 0;
    int ord = 0;
    String code = "";
    String scode = "";
    String pscode = "";
    @Enumerated(value = EnumType.STRING)
    RegionType type = RegionType.unknown;
    String name = "";
    String shortname = "";
    String enname = "";
    String enshortname = "";
    protected String alias;

    double latitude = 0;
    double longitude = 0;


    @Column(length = 64)
    protected String zipcode;
    protected String memo;

    protected boolean skip;

    public RegionItem() {
    }

    public void parseByLine(String line) {
        if (line == null || line.length() == 0) {
            return;
        }
//        line=line.replace("\"","");
//        System.out.println("line "+line);
        String[] list = line.split("\t");
        if (list.length < 17) {
            return;
        }

        setId(ValueUtil.toInt(list[0].replace("\"","")));
        setPid(ValueUtil.toInt(list[1].replace("\"","")));
        setCode(ValueUtil.toString(list[2].replace("\"","")));
        setScode(ValueUtil.toString(list[3].replace("\"","")));
        setPscode(ValueUtil.toString(list[4].replace("\"","")));
        setName(ValueUtil.toString(list[5].replace("\"","")));
        setShortname(ValueUtil.toString(list[6].replace("\"","")));
        setAlias(ValueUtil.toString(list[7].replace("\"","")));
        setZipcode(ValueUtil.toString(list[8].replace("\"","")));
        setLatitude(ValueUtil.toDouble(list[9].replace("\"","")));
        setLongitude(ValueUtil.toDouble(list[10].replace("\"","")));
        setLevel(ValueUtil.toInt(list[11].replace("\"","")));
        setOrd(ValueUtil.toInt(list[12].replace("\"","")));
        setEnname(ValueUtil.toString(list[13].replace("\"","")));
        setSkip(ValueUtil.toBoolean(list[14].replace("\"","")));
        setEnshortname(ValueUtil.toString(list[15].replace("\"","")));
        setType(ValueUtil.toEnum(list[16].replace("\"",""), RegionType.class));
    }

    public List<Integer> findParantIds(boolean excludeSelf) {
        String code = this.scode;
        if (excludeSelf) {
            code = this.pscode;
        }
        List<Integer> ids = new ArrayList<>();
        if (code.equals("R")) {
            return ids;
        }
        String[] strings = code.split("_");
        for (String string : strings) {
            if (string.equals("R")) continue;
            ids.add(Integer.valueOf(string));
        }
        return ids;
    }

    public int getOrd() {
        return ord;
    }

    public void setOrd(int ord) {
        this.ord = ord;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getPid() {
        return pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getScode() {
        return scode;
    }

    public void setScode(String scode) {
        this.scode = scode;
    }

    public String getPscode() {
        return pscode;
    }

    public void setPscode(String pscode) {
        this.pscode = pscode;
    }

    public RegionType getType() {
        return type;
    }

    public void setType(RegionType type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortname() {
        return shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public String getEnname() {
        return enname;
    }

    public void setEnname(String enname) {
        this.enname = enname;
    }

    public String getEnshortname() {
        return enshortname;
    }

    public void setEnshortname(String enshortname) {
        this.enshortname = enshortname;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getZipcode() {
        return zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public boolean isSkip() {
        return skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public enum RegionType {
        global("全球"),
        continents("五大洲"),
        country("国家"),
        area("地区"),
        State("州"),
        province("省"),
        provincearea("省级地区"),
        city("城市"),
        county("县"),
        township("乡镇"),
        village("村"),
        unknown("未知");

        String display;

        public static List<RegionType> findTypes(RegionType beginType, RegionType endType) {
            if (beginType.ordinal() > endType.ordinal()) {
                throw new RuntimeException("beginType must be less than endType.");
            } else {
                List<RegionType> list = new ArrayList();
                RegionType[] values = values();
                RegionType[] var4 = values;
                int var5 = values.length;

                for (int var6 = 0; var6 < var5; ++var6) {
                    RegionType type = var4[var6];
                    if (type.ordinal() >= beginType.ordinal() && type.ordinal() <= endType.ordinal()) {
                        list.add(type);
                    }
                }

                return list;
            }
        }

        private RegionType(String display) {
            this.display = display;
        }

        public String getDisplay() {
            return this.display;
        }

        public void setDisplay(String display) {
            this.display = display;
        }
    }
}

