package org.jsmth.faker;

import java.util.*;

/**
 * User: 马生录（mason
 * Date: 13-7-16
 * Time: 上午9:31
 */
public class FakerPicker {
    public static final String DEFAULT_STRING_SPLIT = " ";

    public static <T> String putString(Set<T> set, int length) {
        return putString(set, length, DEFAULT_STRING_SPLIT);
    }

    public static <T> String putString(Set<T> set, int length, String split) {
        StringBuilder sb = new StringBuilder();
        Set<T> sSet = multiPick(set, length);
        for (T s : sSet) {
            sb.append(s).append(split);
        }
        return sb.toString();
    }


    public static <T> String putString(T[] set, int length) {
        return putString(set, length, DEFAULT_STRING_SPLIT);
    }

    public static <T> String putString(T[] set, int length, String split) {
        StringBuilder sb = new StringBuilder();
        Set<T> sSet = multiPick(set, length);
        for (T s : sSet) {
            sb.append(s).append(split);
        }
        if (sb.toString() != "") {
            sb.delete(sb.length() - 1, sb.length());
        }
        if (sb.toString().endsWith("\n")) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public static String putString(Set<Map.Entry<String, String>> set, String split, String bothSplit) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : set) {
            if (builder.length() > 0)
                builder.append(split);
            builder.append(entry.getKey());
            builder.append(bothSplit);
            builder.append(entry.getValue());
        }
        if (builder.toString().endsWith("\n")) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    public static Map.Entry<String, String> splitString(String text, String split) {
        String[] values = text.split(split);
        if (values.length < 2)
            return new AbstractMap.SimpleEntry<String, String>(values[0], "");
        return new AbstractMap.SimpleEntry<String, String>(values[0], values[1]);
    }


    public static <T> T pick(Set<T> set) {
        if (set.size() == 0) return null;

        double v = set.size() * Math.random();
        int count = 0;
        for (T t : set) {
            count++;
            if (count < v || count >= set.size()) {
                return t;
            }
        }
        return null;
    }

    public static <K, V> K pick(Map<K, V> map) {
        if (map.size() == 0) return null;

        double v = map.size() * Math.random();
        int count = 0;
        for (K k : map.keySet()) {
            count++;
            if (count < v || count >= map.size()) {
                return k;
            }
        }
        return null;
    }

    public static <T> T pick(List<T> list) {
        if (list.size() == 0) return null;

        double v = list.size() * Math.random();
        return list.get((int) v);
    }

    public static <T> T pick(T[] arr) {
        if (arr.length == 0) return null;

        double v = arr.length * Math.random();
        return arr[((int) v)];
    }

    public static <T, F> Map.Entry<T, F> pick(T[] arr, F[] arr2) {
        if (arr.length == 0) return null;

        double v = arr.length * Math.random();
        double z = arr2.length * Math.random();
        return new AbstractMap.SimpleEntry<T, F>(arr[((int) v)], arr2[((int) z)]);
    }

    /**
     * 新算法
     *
     * @param list ff
     * @param amount ff
     * @param <T> ff
     * @return 返回信息
     */
    public static <T> List<T> multiPick1(List<T> list, int amount) {
        return multiPick1(list, amount, false);
    }

    public static <T> List<T> multiPick1(List<T> list, int amount, boolean isoverride) {
        List<T> result = new LinkedList<T>();
        List<T> temp = new LinkedList<T>(list);
        int count = amount;
        for (int index = 0; index < amount; index++) {
            int select = (int) (Math.random() * count);
            result.add(temp.get(select));
            temp.remove(select);
            count--;
        }
        return result;
    }

    // multiPick
    public static <T> Set<T> multiPick(Set<T> set, int amount) {
        if (set.size() == 0) return Collections.emptySet();

        Set<T> ret = new HashSet<T>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(pick(set));
        }
        return ret;
    }

    public static <K, V> Set<K> multiPick(Map<K, V> map, int amount) {
        if (map.size() == 0) return Collections.emptySet();

        Set<K> ret = new HashSet<K>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(pick(map));
        }
        return ret;
    }

    public static <T> List<T> multiPick(List<T> list, int amount) {
        return multiPick(list, amount, false);
    }

    public static <T> List<T> multiPick(List<T> list, int amount, boolean isoverride) {
        if (list.size() == 0) return Collections.emptyList();

        List<T> ret = new ArrayList<T>(amount);
        for (int i = 0; i < amount; i++) {
            if (isoverride) {
                for (int index = 0; index < 1000; index++) {
                    T pick = pick(list);
                    if (!ret.contains(pick)) {
                        ret.add(pick);
                        break;
                    }
                }
            } else {
                ret.add(pick(list));
            }
        }
        return ret;
    }


    public static <T> Set<T> multiPick(T[] arr, int amount) {
        if (arr.length == 0) return Collections.emptySet();

        Set<T> ret = new HashSet<T>(amount);
        while (ret.size() < amount) {
            ret.add(pick(arr));
        }
        return ret;
    }

    public static <T, F> Set<Map.Entry<T, F>> multiPick(T[] arr, F[] arr2, int amount) {
        if (arr.length == 0) return Collections.emptySet();

        Set<Map.Entry<T, F>> ret = new HashSet<Map.Entry<T, F>>(amount);
        while (ret.size() < amount) {
            ret.add(pick(arr, arr2));
        }
        return ret;
    }

    public static Set<Map.Entry<String, String>> multiPick(String[] arr, String split, int amount) {
        if (arr.length == 0) return Collections.emptySet();

        Set<Map.Entry<String, String>> ret = new HashSet<Map.Entry<String, String>>(amount);
        while (ret.size() < amount) {
            ret.add(splitString(pick(arr), split));
        }
        return ret;
    }
}
