package org.jsmth.faker;

import java.util.Map;
import java.util.Set;

/**
 * User: 马生录（mason
 * Date: 13-7-16
 * Time: 上午9:30
 */
public class FakerPassport extends AbstractFaker {
    public static final String CN_IDCARD = "CN_IDCARD";
    public static final String EN_IDCARD = "EN_IDCARD";
    public static final String CN_NAMEIDCARD = "CN_NAMEIDCARD";
    public static final String EN_NAMEIDCARD = "EN_NAMEIDCARD";
    public static final String EN_ZIPCODE = "EN_ZIPCODE";
    public static final String CN_ZIPCODE = "CN_ZIPCODE";

    static FakerPassport instance = new FakerPassport();

    @Override
    protected String getKeyName(String key) {
        if (key.equals(CN_IDCARD)) {
            return "cn_idcard.txt";
        }
        if (key.equals(EN_IDCARD)) {
            return "en_idcard.txt";
        }
        if (key.equals(CN_NAMEIDCARD)) {
            return "cn_nameidcard.txt";
        }
        if (key.equals(EN_NAMEIDCARD)) {
            return "en_nameidcard.txt";
        }
        if (key.equals(CN_IDCARD)) {
            return "cn_idcard.txt";
        }
        if (key.equals(EN_IDCARD)) {
            return "en_idcard.txt";
        }
        return super.getKeyName(key);
    }

    public static String idCard() {
        return instance.pick(CN_IDCARD);
    }

    public static String idCard(int len) {
        return instance.pick(CN_IDCARD, len);
    }

    public static String nameIdCard() {
        return instance.pick(CN_NAMEIDCARD);
    }

    public static String nameIdCard(int len) {
        return instance.pick(CN_NAMEIDCARD, len);
    }

    public static Map.Entry<String, String> nameIdCardEntry() {
        return FakerPicker.splitString(nameIdCard(),DEFAULT_SPLIT);
    }

    public static Set<Map.Entry<String, String>> nameIdCardEntry(int len) {
        return FakerPicker.multiPick(instance.getMap(CN_NAMEIDCARD),DEFAULT_SPLIT,len);
    }

    public static String enIdCard() {
        return instance.pick(EN_IDCARD);
    }

    public static String enIdCard(int len) {
        return instance.pick(EN_IDCARD, len);
    }

    public static String enNameICard() {
        return instance.pick(EN_NAMEIDCARD);
    }

    public static String enNameICard(int len) {
        return instance.pick(EN_NAMEIDCARD, len);
    }

    public static Map.Entry<String, String> enNameIdCardEntry() {
        return FakerPicker.splitString(enNameICard(),DEFAULT_SPLIT);
    }

    public static Set<Map.Entry<String, String>> enNameIdCardEntry(int len) {
        return FakerPicker.multiPick(instance.getMap(EN_NAMEIDCARD),DEFAULT_SPLIT,len);
    }

    public static String passport() {
        return instance.pick(EN_IDCARD);
    }

    public static String passport(int len) {
        return instance.pick(EN_IDCARD, len);
    }

    public static String zipCode() {
        return instance.pick(CN_ZIPCODE);
    }

    public static String zipCode(int len) {
        return instance.pick(CN_ZIPCODE, len);
    }

    public static String enZipCode() {
        return instance.pick(EN_ZIPCODE);
    }

    public static String enZipCode(int len) {
        return instance.pick(EN_ZIPCODE, len);
    }

}

