package org.jsmth.faker;

/**
 * User: 马生录（mason
 * Date: 13-7-16
 * Time: 上午9:31
 */
public class FakerInternet extends AbstractFaker {
    public static final String URL = "URL";
    public static final String IMAGE = "IMAGE";
    public static final String FILE = "FILE";
    public static final String JPG = "JPG";
    public static final String GIF = "GIF";
    public static final String PNG = "PNG";
    public static final String CSS = "CSS";
    public static final String JS = "JS";
    public static final String PPT = "PPT";
    public static final String DOC = "DOC";
    public static final String SWF = "SWF";
    public static final String ZIP = "ZIP";

    static FakerInternet instance = new FakerInternet();

    @Override
    protected String getKeyName(String key) {
        if (key.equals(URL)) {
            return "net_url.txt";
        }
        if (key.equals(DOC)) {
            return "net_doc.txt";
        }
        if (key.equals(GIF)) {
            return "net_gif.txt";
        }
        if (key.equals(IMAGE)) {
            return "net_image.txt";
        }
        if (key.equals(JPG)) {
            return "net_jpg.txt";
        }
        if (key.equals(PNG)) {
            return "net_png.txt";
        }
        if (key.equals(PPT)) {
            return "net_ppt.txt";
        }
        if (key.equals(SWF)) {
            return "net_swf.txt";
        }
        if (key.equals(ZIP)) {
            return "net_zip.txt";
        }
        if (key.equals(FILE)) {
            return "net_file.txt";
        }
        return super.getKeyName(key);
    }

    public static String url() {
        return instance.pick(URL);
    }

    public static String url(int len) {
        return instance.pick(URL, len);
    }

    public static String doc() {
        return instance.pick(DOC);
    }

    public static String doc(int len) {
        return instance.pick(DOC, len);
    }

    public static String file() {
        return instance.pick(FILE);
    }

    public static String file(int len) {
        return instance.pick(FILE, len);
    }

    public static String gif() {
        return instance.pick(GIF);
    }

    public static String gif(int len) {
        return instance.pick(GIF, len);
    }

    public static String image() {
        return instance.pick(IMAGE);
    }

    public static String image(int len) {
        return instance.pick(IMAGE, len);
    }

    public static String jpg() {
        return instance.pick(JPG);
    }

    public static String jpg(int len) {
        return instance.pick(JPG, len);
    }

    public static String png() {
        return instance.pick(PNG);
    }

    public static String png(int len) {
        return instance.pick(PNG, len);
    }

    public static String swf() {
        return instance.pick(SWF);
    }

    public static String swf(int len) {
        return instance.pick(SWF, len);
    }

    public static String zip() {
        return instance.pick(ZIP);
    }

    public static String zip(int len) {
        return instance.pick(ZIP, len);
    }
}
