package org.jsmth.faker;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * User: 马生录（mason
 * Date: 13-7-16
 * Time: 上午9:30
 */
public class FakerDateTime extends AbstractFaker {
    public static final String COMPAT_DATE = "yyyyMMdd";
    public static final String COMPAT_DATETIMR = "yyyyMMddHHmmss";

    public static int dateNumber(int day) {
        return date2Number(date(getNowDateNumber(), day));
    }

    public static int dateNumber(int startDate, int endDate) {
        return date2Number(date(startDate, endDate));
    }

    public static Date date(int day) {
        return date(getNowDateNumber(), day);
    }

    public static Date date(int startDate, int endDate) {
        int a = startDate;
        int b = endDate;
        if (startDate > endDate) {
            a = endDate;
            b = startDate;
        }
        return date(number2Date(a), number2Date(b));
    }

    public static Date date(long longStartTime, long longEndTime) {
        long a = longStartTime;
        long b = longEndTime;
        if (longStartTime > longEndTime) {
            a = longEndTime;
            b = longStartTime;
        }
        return date(new Date(a), new Date(b));
    }

    public static Date date(Date start, Date end) {
        long a = start.getTime();
        long b = end.getTime();
        if (a > b) {
            a = end.getTime();
            b = start.getTime();
        }
        return new Date((long) ((b - a) * Math.random()) + a);
    }

    public static int getNowDateNumber() {
        return date2Number(new Date());
    }

    public static int getNowDatetimeNumber() {
        return datetime2Number(new Date());
    }

    public static int date2Number(Date date) {
        return datetime2Number(COMPAT_DATE, date);
    }

    public static int datetime2Number(Date datetime) {
        return datetime2Number(COMPAT_DATETIMR, datetime);
    }

    public static int datetime2Number(String pattern, Date datetime) {
        try {
            return Integer.valueOf(fromatDateTime(pattern, datetime));
        } catch (ParseException e) {
            return 0;
        }
    }

    /**
     * @param numberDate 格式 20120303
     * @return 返回信息
     */
    public static Date number2Date(int numberDate) {
        return number2DateTime(COMPAT_DATE, numberDate);
    }

    /**
     * @param numberDatetime 格式 20120303030412
     * @return 返回信息
     */
    public static Date number2DateTime(int numberDatetime) {
        return number2DateTime(COMPAT_DATETIMR, numberDatetime);
    }

    /**
     * @param pattern 模式 yyyyMMdd
     * @param date ss    格式 20120303
     * @return 返回信息
     */
    public static Date number2DateTime(String pattern, int date) {
        try {
            return parseDateTime(pattern, String.valueOf(date));
        } catch (ParseException e) {
            return new Date();
        }
    }

    public static Date parseDateTime(String pattern, String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.parse(date);
    }

    public static String fromatDateTime(String pattern, Date date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }
}

