package org.jsmth.faker;

import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

import java.io.*;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * User: 马生录（mason
 * Date: 13-7-16
 * Time: 上午9:31
 */
public class AbstractFaker {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public HashMap<String, String[]> cacheMap = new HashMap<String, String[]>();
    public static final String DEFAULT_SPLIT = "\r\n";
    public static final String DEFAULT_BASE_PATH = "/org/smthjava/faker/resources";
    public static final String DEFAULT_STRING_SPLIT = " ";
    public static final String DEFAULT_NULL_SPLIT = "";
    public static final String DEFAULT_TAB_SPLIT = "\t";

    public File getClassPathResourceFile(String resourceString) {
        ClassPathResource resource = new ClassPathResource(resourceString);
        try {
            return resource.getFile();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String pick(String key, String split) {
        return pick(key, 1, split);
    }

    public String pick(String key) {
        return pick(key, 1);
    }

    public String pick(String key, int len) {
        return pick(key, len, FakerPicker.DEFAULT_STRING_SPLIT);
    }


    public String pick(String key, int len, String split) {
        if (!isLoad(key)) return "";
        StringBuilder builder = new StringBuilder();
        String[] caches = cacheMap.get(key);
        return FakerPicker.putString(caches, len, split);
    }

    public Map.Entry<String, String> bothPick(String key1, String key2) {
        String[] caches1 = getMap(key1);
        String[] caches2 = getMap(key2);
        return FakerPicker.pick(caches1, caches2);
    }

    public Set<String> multiPick(String key, int len) {
        String[] caches = getMap(key);
        return FakerPicker.multiPick(caches, len);
    }

    public Set<Map.Entry<String, String>> multiPick(String key1, String key2, int amount) {
        String[] caches1 = getMap(key1);
        String[] caches2 = getMap(key2);
        return FakerPicker.multiPick(caches1, caches2, amount);
    }

    public boolean isLoad(String key) {
        if (cacheMap.containsKey(key)) {
            return true;
        }
        putResourceMapByName(key, getKeyName(key));
        return cacheMap.containsKey(key);
    }

    public String[] getMap(String key) {
        if (!isLoad(key)) return new String[]{};
        return cacheMap.get(key);
    }

    protected String getKeyName(String key) {
        return "";
    }

    public String[] putResourceStringMap(String resourceString) {
        return putResourceStringMap(resourceString, DEFAULT_SPLIT);
    }

    public String[] putResourceStringMap(String resourceString, String split) {
        ClassPathResource resource = new ClassPathResource(resourceString);
        logger.debug("read resource " + resourceString);
        try {
            return FileUtils.readFileToString(resource.getFile(), "utf8").split(split);
        } catch (FileNotFoundException e) {
            return getJarResource(this.getClass(), resourceString, "utf8").split(split);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJarResource(Class javaClass, String path, String encoding) {
        URL url = javaClass.getResource(path);// 获取定位资源URL对象
        StringBuilder builder = new StringBuilder();
        try {
            InputStream stream = url.openStream();// 打开fileURL对应的文件流
            BufferedReader bufferedreader = new BufferedReader(// 创建一个缓冲字符输入流
                    new InputStreamReader(stream, encoding));
            String str;
            while ((str = bufferedreader.readLine()) != null) {// 从缓冲字符输入流中按行读取信息
                builder.append(str + "\r\n");
            }
            stream.close();// 关闭流
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }


    public void putResourceMap(String key, String resourceString) {
        putResourceMap(key, resourceString, DEFAULT_SPLIT);
    }

    public void putResourceMap(String key, String resourceString, String split) {
        String[] map = putResourceStringMap(resourceString, split);
        cacheMap.put(key, map);
    }

    public void putResourceMapByName(String key, String name) {
        putResourceMapByName(key, name, DEFAULT_SPLIT);
    }

    public void putResourceMapByName(String key, String name, String split) {
        putResourceMap(key, DEFAULT_BASE_PATH + "/" + name, split);
    }
}
