package org.jsmth.spring.test;

import org.junit.After;
import org.junit.Before;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.transaction.AfterTransaction;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;

/**
 * 数据库测试的基础类，它默认注入一个名为 transactionManager 的事务管理器。
 * 如果spring容器中并没有含有此名称的事务管理器
 * 请在单元测试类上加标记annotation：
 * 
 * TransactionConfiguration("fooTxManager")
 * 
 * 其中fooTxManager是所需的事务管理器
 *
 * @author mason
 */
@TransactionConfiguration(defaultRollback = true)
@TestExecutionListeners(listeners = {TransactionalTestExecutionListener.class}, inheritListeners = true)
public class BaseRollbackTest extends BaseDatabaseTest {

    public BaseRollbackTest() {
    }

    @Before
    public void before() {

    }

    @After
    public void after() {

    }

    @BeforeTransaction
    public void beforeTransaction() {

    }

    @AfterTransaction
    public void afterTransaction() {

    }
}
