package org.jsmth.spring.test;

import org.jsmth.data.jdbc.JdbcDao;
import org.junit.After;
import org.junit.Before;
import javax.sql.DataSource;

/**
 * 基础的数据库测试类，可以根据需要注入dataSource
 *
 * @author mason
 */
public class BaseDatabaseTest extends BaseTest {

    protected DataSource dataSource;
    protected JdbcDao jdbcDao;

    public BaseDatabaseTest() {
    }

    @Before
    public void before() {

    }

    @After
    public void after() {

    }

    protected JdbcDao getJdbcDao() {
        if (jdbcDao == null) {
            jdbcDao = new JdbcDao(dataSource);
        }
        return jdbcDao;
    }

    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}
