package org.jsmth.jpa.sql;

import org.jsmth.jpa.entity.EntityHelper;

/**
 * Created by mason on 2017/8/25.
 */
public class SqlBuilder {

    public static <T> String query(Class<T> tClass, String select, String where){
        return query(tClass,select,where,"");
    }
    public static <T> String query(Class<T> tClass, String select, String where, String order){
        return query(tClass,select,where,order,"");
    }
    public static <T> String query(Class<T> tClass, String select, String where, String order, String group){
        String tableName = EntityHelper.getTableName(tClass);
        StringBuilder sql=new StringBuilder();
        sql.append("SELECT ");
        if(select==null || "".equals(select)){
            sql.append("*");
        }else {
            sql.append(select);
        }
        sql.append(" FROM ");
        sql.append(tableName);
        if(where!=null && where.length()>0) {
            sql.append(" WHERE ");
            sql.append(where);
        }
        if(order!=null && order.length()>0) {
            sql.append(" ORDER BY ");
            sql.append(order);
        }
        if(group!=null && group.length()>0) {
            sql.append(" GROUP BY ");
            sql.append(group);
        }
        return sql.toString();
    }

    public static <T> String delete(Class<T> tClass, String where, String order, String group){
        String tableName = EntityHelper.getTableName(tClass);
        StringBuilder sql=new StringBuilder();
        sql.append("DELETE ");
        sql.append(" FROM ");
        sql.append(tableName);
        if(where!=null && where.length()>0) {
            sql.append(" WHERE ");
            sql.append(where);
        }
        if(order!=null && order.length()>0) {
            sql.append(" ORDER BY ");
            sql.append(order);
        }
        if(group!=null && group.length()>0) {
            sql.append(" GROUP BY ");
            sql.append(group);
        }
        return sql.toString();
    }
    public static <T> String update(Class<T> tClass, String setSql, String where){
        String tableName = EntityHelper.getTableName(tClass);
        StringBuilder sql=new StringBuilder();
        sql.append("UPDATE ");
        sql.append(tableName);
        sql.append(" SET ");
        sql.append(setSql);
        if(where!=null && where.length()>0) {
            sql.append(" WHERE ");
            sql.append(where);
        }
        return sql.toString();
    }
}
