package org.jsmth.jpa.repository;

import org.jsmth.jpa.entity.EntityHelper;
import org.jsmth.jpa.sql.SqlBuilder;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 2017/8/25.
 */
public class EntityDaoRepositoryImpl<T, ID extends Serializable> extends SimpleJpaRepository<T, ID> implements EntityDaoRepository<T, ID> {
    EntityManager entityManager;
    JpaEntityInformation<T, ?> entityInformation;

    public EntityDaoRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
        this.entityInformation=entityInformation;
    }



    @Override
    public List<T> findModels(Class<T> tClass, String where, Object... params) {
        String sql = SqlBuilder.query(tClass, "", where);
        Query query = entityManager.createQuery(sql, tClass);
        List result = query.getResultList();
        return result;
    }

    public <C> List<C> findColumns(Class entityClass, Class<C> cClass,String columnName, String where, Object... params) {
        String sql = SqlBuilder.query(entityClass, columnName, where);
        Query query = entityManager.createQuery(sql);
        List result = query.getResultList();
        return result;
    }

    public List<Map> findMaps(Class entityClass, String where, Object... params) {
        return null;
    }

    public List<Map> findMaps(Class entityClass, String select, String where, Object... params) {
        return null;
    }

    public <K> List<K> findIds(Class entityClass, Class<K> kClass, String where, Object... params) {
        return findColumns(entityClass, kClass, EntityHelper.DEFAULT_ENTITY_ID, where, params);
    }

    @Override
    public <T1> T1 getModel(Class<T1> t1Class, String where, Object... params) {
//        List<T> models = (List<T>) findModels(tClass, where, params);
        return null;
    }

    public <C> C getColumn(Class entityClass, Class<C> cClass,String columnName, String where, Object... params) {
        return null;
    }

    public Map getMap(Class entityClass, String where, Object... params) {
        return null;
    }

    public Map getMap(Class entityClass, String select, String where, Object... params) {
        return null;
    }

    public <K> K getId(Class entityClass, Class<K> kClass, String where, Object... params) {
        return getColumn(entityClass, kClass, EntityHelper.DEFAULT_ENTITY_ID, where, params);
    }

    public int update(Class entityClass, String setSql, String where, Object... params) {
        return 0;
    }

    public int update(Object entity, String where, Object... params) {
        return 0;
    }

    public int delete(Class entityClass, String where, Object... params) {
        return 0;
    }

    public int deleteById(Class entityClass, Object id) {
        return 0;
    }

    public int insert(Class entityClass, Map<String, Object> fieldValues) {
        return 0;
    }

    public Object insert(Object entity) {
        return 0;
    }

}
