package org.jsmth.jpa.repository;

import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;

import javax.persistence.EntityManager;
import java.io.Serializable;

/**
 * Created by mason on 2017/8/25.
 */
public class EntityDaoRepositoryFactory extends JpaRepositoryFactory {

    private final EntityManager em;

    public EntityDaoRepositoryFactory(EntityManager entityManager) {
        super(entityManager);
        this.em = entityManager;
    }

    @Override
    protected <T, ID extends Serializable> SimpleJpaRepository<?, ?> getTargetRepository(RepositoryInformation information, EntityManager entityManager) {
        if (EntityDaoRepository.class.isAssignableFrom(information.getRepositoryBaseClass())) {
            JpaEntityInformation<?, Serializable> entityInformation = getEntityInformation(information.getDomainType());
            EntityDaoRepositoryImpl<?, Serializable> repository = new EntityDaoRepositoryImpl(entityInformation, em);
            return repository;
        }
        return super.getTargetRepository(information, entityManager);
    }

    @Override
    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (EntityDaoRepository.class.isAssignableFrom(metadata.getRepositoryInterface())) {
            return EntityDaoRepositoryImpl.class;
        }
        return super.getRepositoryBaseClass(metadata);
    }

}