package org.jsmth.jpa.repository;

import org.springframework.data.jpa.repository.JpaRepository;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 2017/8/25.
 */
public interface EntityDaoRepository<T, ID extends Serializable>
        extends JpaRepository<T, ID> {

    List<T> findModels(Class<T> tClass, String where, Object... params);

    <C> List<C> findColumns(Class entityClass, Class<C> cClass,String columnName, String where, Object... params);

    List<Map> findMaps(Class entityClass, String where, Object... params);

    List<Map> findMaps(Class entityClass, String select, String where, Object... params);

    <K> List<K> findIds(Class entityClass, Class<K> kClass, String where, Object... params);

    <T> T getModel(Class<T> tClass, String where, Object... params);

    <C> C getColumn(Class entityClass, Class<C> cClass,String columnName, String where, Object... params);

    Map getMap(Class entityClass, String where, Object... params);

    Map getMap(Class entityClass, String select, String where, Object... params);

    <K> K getId(Class entityClass, Class<K> kClass, String where, Object... params);

    int update(Class entityClass, String setSql, String where, Object... params);

    int update(Object entity, String where, Object... params);

    int delete(Class entityClass, String where, Object... params);

    int deleteById(Class entityClass, Object id);

    int insert(Class entityClass, Map<String, Object> fieldValues);

    Object insert(Object entity);
}
