package org.jsmth.jpa.entity;

import org.springframework.util.Assert;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * Created by mason on 2017/8/25.
 */
public class EntityHelper {
    public static final String DEFAULT_ENTITY_ID="id";

    /**
     * 检测是否为可持久化的实体
     *
     * @param clazz d
     * @param <T> d
     * @return 返回信息
     */
    public static <T> boolean isEntity(Class<T> clazz) {
        return clazz.getAnnotation(Entity.class) != null || clazz.getAnnotation(Table.class) != null;
    }
    public static <T> String getTableName(Class<T> clazz) {
        Assert.isTrue(isEntity(clazz));

        Table table = clazz.getAnnotation(Table.class);
        if (table != null && !table.name().equals(""))
            return table.name();

        org.hibernate.annotations.Table htable = clazz.getAnnotation(org.hibernate.annotations.Table.class);
        if (htable != null && !htable.appliesTo().equals(""))
            return htable.appliesTo();

        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity != null && !entity.name().equals(""))
            return entity.name();

        return clazz.getSimpleName();
    }
}
