package org.jsmth.jorm.stateservice;

import org.jsmth.jorm.daoservice.ReadWriteCacheableEntityDaoService;

import java.io.Serializable;

/**
 * User: 马生录（mason
 * Date: 13-1-18
 * Time: 下午1:28
 */
public abstract class ReadWriteCacheableStateEntityDaoService<KEY extends Serializable, MODEL extends IStateModel<KEY>> extends ReadWriteCacheableEntityDaoService<KEY, MODEL> {

    public ReadWriteCacheableStateEntityDaoService(Class<MODEL> entityClass) {
        super(entityClass);
    }

    public void addStateCountFieldValue(int field, KEY id) {
        countStateCountFieldValue(field, id, 1);
    }

    public void subStateCountFieldValue(int field, KEY id) {
        countStateCountFieldValue(field, id, -1);
    }

    public void countStateCountFieldValue(int field, KEY id, int value) {
        MODEL model = getByIdOrNew(id);
        int fieldValue = model.getStateCountFieldValue(field, id);
        fieldValue = fieldValue + value;
        if (fieldValue < 0)
            fieldValue = 0;
        model.setStateCountFieldValue(field, id, fieldValue);
        update(model);
    }
}

