package org.jsmth.jorm.service;

import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.exception.SmthExceptionDict;
import org.jsmth.exception.SmthExceptionDictHandler;

/**
 * 功能：
 * 马生录(mason) on 2015/10/14.
 */
public class SmthCheckExceptionUtil {
    public static  <T> T checkIsNull(T model, boolean checkNull) throws SmthDataAccessException {
        return checkIsNull(model, checkNull, SmthExceptionDict.ModelNullException);
    }
    public static  <T> T checkIsNull(T model, boolean checkNull, String errorMessage, String errorCode) throws SmthDataAccessException{
        if(model==null && checkNull){
            throw new SmthDataAccessException(errorMessage,errorCode);
        }
        return model;
    }
    public static  <T> T checkIsNull(T model, boolean checkNull, SmthExceptionDictHandler exceptionEnum) throws SmthDataAccessException{
        return checkIsNull(model, checkNull, exceptionEnum.getMessage(), exceptionEnum.getCode());
    }
}
