package org.jsmth.jorm.service;

import org.apache.commons.lang.ArrayUtils;
import org.jsmth.jorm.action.QueryAction;
import org.jsmth.jorm.action.cache.QueryCacheableAction;
import org.jsmth.domain.Identifier;
import org.jsmth.cache.Cache;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 在提供实体缓存的基础上，进一步可以提供查询缓存的实体服务基类
 * User: mason
 * Date: 2010-1-20
 * Time: 17:47:50
 */
public abstract class QueryCacheableService<KEY extends Serializable, MODEL extends Identifier<KEY>, DAO extends EntityDao<KEY, MODEL>> extends EntityCacheableService<KEY, MODEL, DAO> {

    private Map<String, QueryCacheableAction<KEY, MODEL>> actions = new ConcurrentHashMap<String, QueryCacheableAction<KEY, MODEL>>();

    protected abstract Cache getQueryCache();

    @Override
    protected <ACTION extends QueryAction<KEY, MODEL>> ACTION buildQueryAction(Class<ACTION> clazz, Object... params) {
        ACTION action;
        try {
            action = clazz.newInstance();
        } catch (Exception e) {
            throw new RuntimeException("CacheAction class[" + clazz + "] must be public and contains a default Constructor", e);
        }
        action.prepare(getClass().getName(), isUseCache(), getEntityDao().getEntityClass(), getEntityDao().getJdbcDao(), getEntityCache(), params);
        return action;
    }

    public <ACTION extends QueryCacheableAction<KEY, MODEL>> void onEntityInsert(MODEL model, Class<ACTION>... classes) {
        if (ArrayUtils.isEmpty(classes)) return;
        for (Class<ACTION> clazz : classes) {
            if (clazz != null) {
                getEmptyQueryAction(clazz).onEntityInsert(model);
            }
        }
    }

    public <ACTION extends QueryCacheableAction<KEY, MODEL>> void onEntityDelete(MODEL model, Class<ACTION>... classes) {
        if (ArrayUtils.isEmpty(classes)) return;
        for (Class<ACTION> clazz : classes) {
            if (clazz != null) {
                getEmptyQueryAction(clazz).onEntityDelete(model);
            }
        }
    }

    @SuppressWarnings({"unchecked"})
    private <ACTION extends QueryCacheableAction<KEY, MODEL>> ACTION getEmptyQueryAction(Class<ACTION> clazz) {
        QueryCacheableAction<KEY, MODEL> act = actions.get(clazz.getName());
        if (act == null) {
            try {
                act = clazz.newInstance();
            } catch (Exception e) {
                throw new RuntimeException("CacheAction class[" + clazz + "] must be public and contains a default Constructor", e);
            }
            actions.put(clazz.getName(), act);
        }
        return (ACTION) act;
    }
}
