package org.jsmth.jorm.service;

import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.jorm.jdbc.*;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * 功能：
 * 马生录(mason) on 2015/5/28.
 */
public class JdbcEntityDao<MODEL> implements RowMapper<MODEL> {
    protected CommonJdbcDao commonJdbcDao;

    protected Class<MODEL> entityClass;

    public JdbcEntityDao(Class<MODEL> entityClass) {
        this.entityClass = entityClass;
    }

    public JdbcEntityDao(Class<MODEL> entityClass,CommonJdbcDao commonJdbcDao) {
        this.entityClass = entityClass;
        setCommonJdbcDao(commonJdbcDao);
    }

    public CommonJdbcDao getCommonJdbcDao() {
        return commonJdbcDao;
    }

    public void setCommonJdbcDao(CommonJdbcDao commonJdbcDao) {
        this.commonJdbcDao = commonJdbcDao;
    }

    public Class<MODEL> getEntityClass() {
        return entityClass;
    }

    public void setEntityClass(Class<MODEL> entityClass) {
        this.entityClass = entityClass;
    }

    //<editor-fold desc="RowMapper">
    @Override
    public MODEL mapRow(ResultSet resultSet, int i) throws SQLException {
        MODEL nt = null;
        try {
            nt = entityClass.newInstance();
        } catch (Exception e) {
            e.printStackTrace();
            throw  new SQLException(e);
        }
        Field[] fields = entityClass.getDeclaredFields();
        try {
            nt = entityClass.newInstance();
            for (Field field : fields) {
                //如果结果中没有改field项则跳过
                try {
                    resultSet.findColumn(field.getName());
                } catch (Exception e) {
                    continue;
                }
                //修改相应filed的权限
                boolean accessFlag = field.isAccessible();
                field.setAccessible(true);
                String value = resultSet.getString(field.getName());
                value = value==null?"":value;
                setFieldValue(nt, field, value);

                //恢复相应field的权限
                field.setAccessible(accessFlag);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return nt;
    }


    public static void setFieldValue(Object form, Field field, String value) {

        String elemType = field.getType().toString();

        if (elemType.indexOf("boolean") != -1 || elemType.indexOf("Boolean") != -1) {
            try {
                field.set(form, Boolean.valueOf(value));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (elemType.indexOf("byte") != -1 || elemType.indexOf("Byte") != -1) {
            try {
                field.set(form, Byte.valueOf(value));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (elemType.indexOf("char") != -1 || elemType.indexOf("Character") != -1) {
            try {
                field.set(form, Character.valueOf(value.charAt(0)));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (elemType.indexOf("double") != -1 || elemType.indexOf("Double") != -1) {
            try {
                field.set(form, Double.valueOf(value));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (elemType.indexOf("float") != -1 || elemType.indexOf("Float") != -1) {
            try {
                field.set(form, Float.valueOf(value));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (elemType.indexOf("int") != -1 || elemType.indexOf("Integer") != -1) {
            try {
                field.set(form, Integer.valueOf(value));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (elemType.indexOf("long") != -1 || elemType.indexOf("Long") != -1) {
            try {
                field.set(form, Long.valueOf(value));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else if (elemType.indexOf("short") != -1 || elemType.indexOf("Short") != -1) {
            try {
                field.set(form, Short.valueOf(value));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                field.set(form, (Object) value);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
    //</editor-fold>

    //<editor-fold desc="new method">
    public List<MODEL> query(String sql, Map<String, ?> args) throws SmthDataAccessException {
        return getCommonJdbcDao().query(sql, this, args);
    }
    public MODEL queryForObject(String sql, Map<String, ?> args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForObject(sql, this, args);
    }

    public MODEL queryForObject(String sql, SqlParameterSource args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForObject(sql, this, args);
    }


    public List<MODEL> query(String sql, Object... args) throws SmthDataAccessException {
        return getCommonJdbcDao().query(sql, this, args);
    }

    public List<MODEL> query(String sql, SqlParameterSource args) throws SmthDataAccessException {
        return getCommonJdbcDao().query(sql, this, args);
    }


    public MODEL queryForObject(String sql, Object... args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForObject(sql, this, args);
    }
    //</editor-fold>

    //<editor-fold desc="delegate method">
    public MODEL queryForObject(String sql, Class<MODEL> requiredType, SqlParameterSource args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForObject(sql, requiredType, args);
    }


    public long queryForLong(String sql, Object... args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForLong(sql, args);
    }

    public int update(String sql, SqlParameterSource args) throws SmthDataAccessException {
        return getCommonJdbcDao().update(sql, args);
    }

    public int queryForInt(String sql, Map<String, ?> args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForInt(sql, args);
    }


    public int queryForInt(String sql, Object... args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForInt(sql, args);
    }

    public MODEL queryForObject(String sql, Class<MODEL> requiredType, Map<String, ?> args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForObject(sql, requiredType, args);
    }

    public List<MODEL> query(String sql, RowMapper<MODEL> rm, Map<String, ?> args) throws SmthDataAccessException {
        return getCommonJdbcDao().query(sql, rm, args);
    }


    public int[] batchUpdate(String sql, List<Object[]> batchArgs, int[] argTypes) {
        return getCommonJdbcDao().batchUpdate(sql, batchArgs, argTypes);
    }

    public int queryForInt(String sql, SqlParameterSource args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForInt(sql, args);
    }

    public List<Map<String, Object>> queryForList(String sql, Object... args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForList(sql, args);
    }

    public MODEL queryForObject(String sql, RowMapper<MODEL> rm, Map<String, ?> args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForObject(sql, rm, args);
    }

    public MODEL queryForObject(String sql, RowMapper<MODEL> rm, SqlParameterSource args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForObject(sql, rm, args);
    }

    public List<Map<String, Object>> queryForList(String sql, Map<String, ?> args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForList(sql, args);
    }

    public int[] batchUpdate(String sql, Map<String, ?>[] batchValues) {
        return getCommonJdbcDao().batchUpdate(sql, batchValues);
    }

    public long queryForLong(String sql, SqlParameterSource args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForLong(sql, args);
    }

    public Map<String, Object> queryForMap(String sql, Object... args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForMap(sql, args);
    }

    public MODEL queryForObject(String sql, Class<MODEL> requiredType, Object... args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForObject(sql, requiredType, args);
    }

    public List<MODEL> query(String sql, RowMapper<MODEL> rm, Object... args) throws SmthDataAccessException {
        return getCommonJdbcDao().query(sql, rm, args);
    }

    public List<MODEL> query(String sql, RowMapper<MODEL> rm, SqlParameterSource args) throws SmthDataAccessException {
        return getCommonJdbcDao().query(sql, rm, args);
    }

    public int update(String sql, Map<String, ?> args) throws SmthDataAccessException {
        return getCommonJdbcDao().update(sql, args);
    }

    public long queryForLong(String sql, Map<String, ?> args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForLong(sql, args);
    }

    public int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return getCommonJdbcDao().batchUpdate(sql, batchArgs);
    }

    public List<Map<String, Object>> queryForList(String sql, SqlParameterSource args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForList(sql, args);
    }

    public Map<String, Object> queryForMap(String sql, SqlParameterSource args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForMap(sql, args);
    }

    public int update(String sql, Object... args) throws SmthDataAccessException {
        return getCommonJdbcDao().update(sql, args);
    }

    public Map<String, Object> queryForMap(String sql, Map<String, ?> args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForMap(sql, args);
    }

    public MODEL queryForObject(String sql, RowMapper<MODEL> rm, Object... args) throws SmthDataAccessException {
        return getCommonJdbcDao().queryForObject(sql, rm, args);
    }

    public int[] batchUpdate(String sql, SqlParameterSource[] batchArgs) {
        return getCommonJdbcDao().batchUpdate(sql, batchArgs);
    }

    public void executeDDL(String sql) {
        getCommonJdbcDao().executeDDL(sql);
    }
    //</editor-fold>
}
