package org.jsmth.jorm.service;

import org.jsmth.exception.SmthDataAccessException;
import org.jsmth.domain.Identifier;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 功能：
 * 马生录(mason) on 2015/7/10.
 */
public interface IEntityService<KEY extends Serializable, MODEL extends Identifier<KEY>> {

    void init();


    String getNameById(KEY id);
    Object getPropertyById(KEY id,String propertyName);
    Object getPropertyById(KEY id,String propertyName,Object defaultValue);
    String getStrPropertyById(KEY id,String propertyName);
    String getStrPropertyById(KEY id,String propertyName,String defaultValue);
    int getIntPropertyById(KEY id,String propertyName);
    int getIntPropertyById(KEY id,String propertyName,int defaultValue);
    long getLongPropertyById(KEY id,String propertyName);
    long getLongPropertyById(KEY id,String propertyName,long defaultValue);

    MODEL getById(KEY id) throws SmthDataAccessException;
    MODEL getByIdOrNew(KEY id) throws SmthDataAccessException;
    MODEL getByIdOrNew(KEY id, boolean setid) throws SmthDataAccessException;
    MODEL getByIdOrNew(KEY id, boolean setid, boolean insert) throws SmthDataAccessException;
    MODEL getOrCreateById(KEY id) throws SmthDataAccessException;
    List<MODEL> findAll() throws SmthDataAccessException;
    List<MODEL> findByIds(List<KEY> ids) throws SmthDataAccessException;
    List<MODEL> findByIds(Set<KEY> ids) throws SmthDataAccessException;
    List<MODEL> findByIdsOrNew(List<? extends KEY> ids);
    List<MODEL> findByIdsOrNew(Set<? extends KEY> ids);
    MODEL insert(MODEL entity) throws SmthDataAccessException;
    void insertAll(Collection<MODEL> entities) throws SmthDataAccessException;
    int update(MODEL entity) throws SmthDataAccessException;
    int updateFields(MODEL entity, String... fieldNames) throws SmthDataAccessException;
    int updateAll(Collection<MODEL> entities) throws SmthDataAccessException;
    int updateFeildsAll(Collection<MODEL> entities, String... fieldNames) throws SmthDataAccessException;
    MODEL save(MODEL entity) throws SmthDataAccessException;
    boolean delete(MODEL entity) throws SmthDataAccessException;
    int deleteAll(Collection<MODEL> entities) throws SmthDataAccessException;
    boolean deleteById(KEY id) throws SmthDataAccessException;
    int deleteByIds(Collection<? extends KEY> ids) throws SmthDataAccessException;

    MODEL getSortFirstOne(String fieldName, boolean desc);
    MODEL getFirstModel();
    MODEL getLastModel();

    void copyProperties(Object sourceObject, Object targetObject, boolean copyNullProperty);
    <T> void copyProperties(T orig, T dest) throws Exception;


    void setBeginKey(KEY beginKey,boolean isdelete);
    void setBeginKey(KEY beginKeye);
}
